/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.collections.iter;

import melnorme.utilbox.collections.iter.ICopyableIterator;

public class ChainedIterator<T>
implements ICopyableIterator<T> {
    protected ICopyableIterator<T> firstIterator;
    protected final ICopyableIterator<T> secondIterator;
    protected ICopyableIterator<T> currentIterator;

    public static <U> ICopyableIterator<U> create(ICopyableIterator<U> firstIter, ICopyableIterator<U> secondIter) {
        return new ChainedIterator<U>(firstIter, secondIter);
    }

    public ChainedIterator(ICopyableIterator<T> _firstIter, ICopyableIterator<T> _secondIter) {
        this.firstIterator = _firstIter.optimizedSelf();
        this.secondIterator = _secondIter.optimizedSelf();
        this.currentIterator = this.firstIterator;
        this.updateCurrentIterator();
    }

    public boolean isOnLastIterator() {
        return !this.firstIterator.hasNext();
    }

    protected void updateCurrentIterator() {
        if (!this.currentIterator.hasNext() && this.currentIterator != this.secondIterator) {
            this.currentIterator = this.secondIterator;
        }
    }

    @Override
    public boolean hasNext() {
        return this.currentIterator.hasNext();
    }

    @Override
    public T next() {
        Object next = this.currentIterator.next();
        this.updateCurrentIterator();
        return (T)next;
    }

    @Override
    public ICopyableIterator<T> copyState() {
        if (this.isOnLastIterator()) {
            return this.secondIterator.copyState().optimizedSelf();
        }
        return new ChainedIterator<T>(this.firstIterator.copyState(), this.secondIterator.copyState());
    }

    @Override
    public ICopyableIterator<T> optimizedSelf() {
        if (this.isOnLastIterator()) {
            return this.secondIterator.optimizedSelf();
        }
        this.firstIterator = this.firstIterator.optimizedSelf();
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

