/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.collections;

import java.util.ArrayList;
import java.util.LinkedList;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.ArrayView;
import melnorme.utilbox.collections.ListView;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.tests.CommonTestUtils;
import org.junit.Test;

public class Indexable_Tests
extends CommonTestUtils {
    @Test
    public void testEquals() throws Exception {
        this.testEquals$();
    }

    public void testEquals$() throws Exception {
        this.testEquals(true, ArrayView.create(Indexable_Tests.array(new Object[0])), ListView.create(this.createArrayList(new Object[0])), new ArrayList2(), this.createArrayList(new Object[0]), new LinkedList());
        this.testEquals(true, ArrayView.create(Indexable_Tests.array("Foo", "Bar")), ListView.create(new ArrayList2<String>("Foo", "Bar")), new ArrayList2<String>("Foo", "Bar"), this.createArrayList("Foo", "Bar"));
        this.testEquals(false, new ArrayList2<String>("asdf"), ArrayView.create(Indexable_Tests.array("ss")), ListView.create(new ArrayList2<String>("zzz")), this.createArrayList("Foo"));
        this.testEquals(false, new ArrayList2<String>("one", "twoo"), ArrayView.create(Indexable_Tests.array("xxx")), ListView.create(this.createArrayList(new Object[0])), this.createArrayList(1, 2, 3));
    }

    protected ArrayList<Object> createArrayList(Object ... objs) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.addAll(new ArrayList2<Object>(objs));
        return arrayList;
    }

    protected void testEquals(boolean expectedAreEqual, Object ... objs) {
        Object[] objectArray = objs;
        int n = objs.length;
        int n2 = 0;
        while (n2 < n) {
            Object objA = objectArray[n2];
            Object[] objectArray2 = objs;
            int n3 = objs.length;
            int n4 = 0;
            while (n4 < n3) {
                Object objB = objectArray2[n4];
                if (expectedAreEqual || objA != objB) {
                    this.checkAreEqual(expectedAreEqual, objA, objB);
                }
                ++n4;
            }
            ++n2;
        }
    }

    protected void checkAreEqual(boolean expectedAreEqual, Object objA, Object objB) {
        Assert.AssertNamespace.assertTrue(CoreUtil.areEqual(objA, objB) == expectedAreEqual);
    }

    @Test
    public void testListMethod() throws Exception {
        this.testListMethod$();
    }

    public void testListMethod$() throws Exception {
        Object[] array = ArrayView.create(Indexable_Tests.array("String")).toArray(String.class);
        Indexable_Tests.assertEqualArrays(array, Indexable_Tests.array("String"));
        Assert.AssertNamespace.assertTrue(new ArrayList2<String>("zero", "one", "two", "two").indexOf("two") == 2);
        Assert.AssertNamespace.assertTrue(new ArrayList2<String>("zero", "one", "two", "zero").indexOf("zero") == 0);
        Assert.AssertNamespace.assertTrue(new ArrayList2<String>("zero", "one", "two", "two").lastIndexOf("two") == 3);
        Assert.AssertNamespace.assertTrue(new ArrayList2<String>("zero", "one", "two", "zero").lastIndexOf("zero") == 3);
        Assert.AssertNamespace.assertTrue(new ArrayList2<String>("zero", "one", "two").lastIndexOf("zero") == 0);
    }
}

