/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.collections;

import java.util.function.Function;
import java.util.function.Predicate;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.fntypes.FunctionX;
import melnorme.utilbox.misc.ArrayUtil;
import melnorme.utilbox.misc.CollectionUtil;

public interface Collection2<E>
extends Iterable<E> {
    public int size();

    public boolean isEmpty();

    public <T> Collection2<T> upcastTypeParameter();

    default public <R> ArrayList2<R> map(Function<? super E, ? extends R> evalFunction) {
        return CollectionUtil.map(this, evalFunction);
    }

    default public <R, EXC extends Exception> ArrayList2<R> mapx(FunctionX<? super E, ? extends R, EXC> evalFunction) throws EXC {
        return CollectionUtil.mapx(this, evalFunction);
    }

    default public int indexUntil(Predicate<? super E> predicate) {
        return CollectionUtil.indexUntil(this.iterator(), predicate);
    }

    default public E findElement(Predicate<? super E> predicate) {
        return CollectionUtil.findElement(this.iterator(), predicate);
    }

    default public ArrayList2<E> toArrayList() {
        return new ArrayList2(this);
    }

    default public Object[] toArray() {
        return this.upcastTypeParameter().toArray(Object.class);
    }

    default public <T> T[] toArray(T[] a) {
        Class<?> componentType = a.getClass().getComponentType();
        return this.upcastTypeParameter().toArray(componentType);
    }

    default public E[] toArray(Class<E> componentType) {
        Object[] newArray = ArrayUtil.create(this.size(), componentType);
        this.copyToArray(newArray);
        return newArray;
    }

    default public Object[] copyToArray(Object[] destArray) {
        Assert.AssertNamespace.assertTrue(destArray.length == this.size());
        int i = 0;
        for (Object element : this) {
            destArray[i++] = element;
        }
        return destArray;
    }
}

