/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.collections;

import java.util.Iterator;
import melnorme.utilbox.collections.SimpleChainedIterator;
import melnorme.utilbox.core.Assert;

public class ChainedIterable<E>
implements Iterable<E> {
    protected final Iterable<? extends E> first;
    protected final Iterable<? extends E> second;

    public static <E> ChainedIterable<E> create(Iterable<? extends E> firstIter, Iterable<? extends E> secondIter) {
        return new ChainedIterable<E>(firstIter, secondIter);
    }

    public ChainedIterable(Iterable<? extends E> first, Iterable<? extends E> second) {
        this.first = Assert.AssertNamespace.assertNotNull(first);
        this.second = Assert.AssertNamespace.assertNotNull(second);
    }

    @Override
    public Iterator<E> iterator() {
        return new SimpleChainedIterator<E>(this.first.iterator(), this.second.iterator());
    }

    public <T> ChainedIterable<T> castTypeParam() {
        return this;
    }
}

