/*
 * Decompiled with CFR 0.152.
 */
package melnorme.utilbox.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.stream.Stream;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.CollectionUtil;

public class ArrayList2<E>
extends ArrayList<E>
implements Indexable<E> {
    private static final long serialVersionUID = -9212035453691203439L;

    public static <E> ArrayList2<E> create() {
        return new ArrayList2<E>();
    }

    @SafeVarargs
    public static <E> ArrayList2<E> createFrom(E ... elements) {
        ArrayList2<E> arrayList = new ArrayList2<E>(elements.length);
        arrayList.addElements(elements);
        return arrayList;
    }

    public ArrayList2() {
    }

    public ArrayList2(Collection<? extends E> coll) {
        super(coll);
    }

    public ArrayList2(Collection2<? extends E> coll) {
        super(coll.size());
        this.addAll2(coll);
    }

    public ArrayList2(Iterable<? extends E> coll) {
        this.addAll2(coll);
    }

    public ArrayList2(int initialCapacity) {
        super(initialCapacity);
    }

    @SafeVarargs
    public ArrayList2(E ... elements) {
        this.addElements(elements);
    }

    @SafeVarargs
    public static <E> ArrayList2<E> create(E ... elements) {
        return new ArrayList2<E>(elements.length).addElements(elements);
    }

    @Override
    public boolean equals(Object obj) {
        return Indexable.equals(this, obj);
    }

    @Override
    public int hashCode() {
        return Indexable.hashCode(this);
    }

    @SafeVarargs
    public final ArrayList2<E> addElements(E ... elements) {
        E[] EArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            this.add(element);
            ++n2;
        }
        return this;
    }

    public final ArrayList2<E> addAll2(Iterable<? extends E> iterable) {
        return this.iteratorAddAll(iterable.iterator());
    }

    public final ArrayList2<E> addAll2(Stream<? extends E> stream) {
        return this.iteratorAddAll(stream.iterator());
    }

    public ArrayList2<E> iteratorAddAll(Iterator<? extends E> iterator) {
        return CollectionUtil.addAllFromIterator(this, iterator);
    }

    public <SOURCE> ArrayList2<E> addAll(Collection2<SOURCE> source, Function<SOURCE, E> mapper) {
        return CollectionUtil.addAll(this, source, mapper);
    }

    public ArrayList2<E> addIfNotNull(E element) {
        if (element != null) {
            this.add(element);
        }
        return this;
    }

    @Override
    public Object[] copyToArray(Object[] destArray) {
        return this.toArray(destArray);
    }

    @Override
    public <T> Indexable<T> upcastTypeParameter() {
        return (Indexable)CoreUtil.blindCast(this);
    }

    private static void _generics_test() {
        ArrayList2 arrayListExt = new ArrayList2();
        Collection2 other = arrayListExt.upcastTypeParameter();
    }
}

