/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils.parse;

import melnorme.lang.utils.parse.ICharacterReader;
import melnorme.lang.utils.parse.OffsetBasedCharacterReader;
import melnorme.utilbox.core.Assert;

public class StringCharSource
extends OffsetBasedCharacterReader<RuntimeException>
implements ICharacterReader {
    protected final String source;

    public StringCharSource(String source) {
        this.source = Assert.AssertNamespace.assertNotNull(source);
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public int lookahead(int offset) {
        int index = this.readPosition + offset;
        if (index < 0 || index >= this.source.length()) {
            return -1;
        }
        return this.source.charAt(index);
    }

    @Override
    public String lookaheadString(int offset, int length) throws RuntimeException {
        return this.sourceSubString(offset, offset + length);
    }

    @Override
    public int bufferedCharCount() {
        return this.source.length() - this.readPosition;
    }

    @Override
    public void consume(int amount) throws RuntimeException {
        this.readPosition += amount;
        Assert.AssertNamespace.assertTrue(this.readPosition <= this.source.length());
    }

    @Override
    protected void doUnread() {
    }

    protected String sourceSubString(int startPos, int endPos) {
        return this.source.substring(this.readPosition + startPos, this.readPosition + endPos);
    }
}

