/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils.parse;

import melnorme.lang.utils.parse.IBasicCharSource;
import melnorme.lang.utils.parse.ICharSource;

public class LexingUtils {
    public static <E extends Exception> String consumeUntilDelimiterOrEOS(IBasicCharSource<E> reader, char delimiter) throws E {
        return LexingUtils.consumeUntilDelimiterOrEOS(reader, delimiter, delimiter);
    }

    public static <E extends Exception> String consumeUntilDelimiterOrEOS(IBasicCharSource<E> reader, char delimiter, char escapeChar) throws E {
        StringBuilder sb = new StringBuilder();
        LexingUtils.consumeUntilDelimiter_intoStringBuilder(reader, delimiter, escapeChar, sb);
        return sb.toString();
    }

    public static <E extends Exception> boolean consumeUntilDelimiter_intoStringBuilder(IBasicCharSource<E> reader, char delimiter, char escapeChar, StringBuilder sb) throws E {
        while (reader.hasCharAhead()) {
            char secondChar;
            char consumedChar = reader.nextChar();
            if (consumedChar == delimiter) {
                return false;
            }
            if (consumedChar == escapeChar && reader.hasCharAhead() && ((secondChar = reader.lookaheadChar()) == delimiter || secondChar == escapeChar)) {
                reader.nextChar();
                sb.append(secondChar);
                continue;
            }
            sb.append(consumedChar);
        }
        return true;
    }

    public static <E extends Exception> void advanceDelimitedString(ICharSource<E> reader, char delimiter, char escapeChar) throws E {
        while (reader.hasCharAhead()) {
            char consumedChar = reader.nextChar();
            if (consumedChar == delimiter) break;
            if (consumedChar != escapeChar) continue;
            reader.consumeAny();
        }
    }

    public static <E extends Exception> int skipWhitespace(IBasicCharSource<E> reader) throws E {
        int count = 0;
        while (Character.isWhitespace(reader.lookahead())) {
            reader.consume();
            ++count;
        }
        return count;
    }

    public static <E extends Exception> int skipWhitespaceExceptNL(IBasicCharSource<E> reader) throws E {
        int count = 0;
        while (Character.isWhitespace(reader.lookahead())) {
            if (reader.lookahead() == 10 || reader.lookahead() == 13) break;
            reader.consume();
            ++count;
        }
        return count;
    }

    public static <E extends Exception> String tryConsumeJavaIdentifier(ICharSource<E> reader) throws E {
        int length = LexingUtils.matchJavaIdentifier(reader);
        if (length == 0) {
            return null;
        }
        return reader.consumeString(length);
    }

    public static <E extends Exception> int matchJavaIdentifier(ICharSource<E> reader) throws E {
        int length = 0;
        int la = reader.lookahead(length);
        if (la == -1 || !Character.isJavaIdentifierStart(la)) {
            return length;
        }
        ++length;
        while ((la = reader.lookahead(length)) != -1 && Character.isJavaIdentifierPart(la)) {
            ++length;
        }
        return length;
    }

    public static <E extends Exception> String readJavaIdentifier(ICharSource<E> reader) throws E {
        int length = LexingUtils.matchJavaIdentifier(reader);
        return reader.consumeString(length);
    }

    public static <E extends Exception> String determineNewlineSequenceAt(ICharSource<E> reader, int offset) throws E {
        int la = reader.lookahead(offset);
        if (la == -1) {
            return "";
        }
        if (la == 10) {
            return "\n";
        }
        if (la == 13) {
            if (reader.lookahead(offset + 1) == 10) {
                return "\r\n";
            }
            return "\r";
        }
        return null;
    }

    public static <E extends Exception> String stringUntilNewline(ICharSource<E> reader) throws E {
        return LexingUtils.stringUntilNewline(reader, 0);
    }

    public static <E extends Exception> String stringUntilNewline(ICharSource<E> reader, int offset) throws E {
        int endPos = offset;
        while (LexingUtils.determineNewlineSequenceAt(reader, endPos) == null) {
            ++endPos;
        }
        return reader.lookaheadString(offset, endPos - offset);
    }

    public static <E extends Exception> String consumeLine(ICharSource<E> reader) throws E {
        int offset = 0;
        if (reader.lookaheadIsEOS()) {
            return null;
        }
        String line = LexingUtils.stringUntilNewline(reader, offset);
        reader.consumeAhead(line);
        reader.consumeAhead(LexingUtils.determineNewlineSequenceAt(reader, offset));
        return line;
    }
}

