/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils.concurrency;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.concurrency.SafeFuture;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.fntypes.CallableX;
import melnorme.utilbox.fields.ListenerListHelper;

public class ConcurrentlyDerivedData<DATA, SELF> {
    protected final ListenerListHelper<IDataChangedListener<SELF>> connectedListeners = new ListenerListHelper();
    protected final ListenerListHelper<IDataUpdateRequestedListener<SELF>> updateRequestedListeners = new ListenerListHelper();
    private DATA data = null;
    private DataUpdateTask<DATA> latestUpdateTask = null;
    private CountDownLatch latch = new CountDownLatch(0);
    protected final DataUpdateFuture asFuture = new DataUpdateFuture();

    public ConcurrentlyDerivedData() {
        this.internalSetData(null);
    }

    protected void internalSetData(DATA newData) {
        this.data = newData;
    }

    public synchronized DATA getStoredData() {
        return this.data;
    }

    protected SELF getSelf() {
        return (SELF)this;
    }

    public synchronized boolean isStale() {
        return this.latestUpdateTask != null;
    }

    public synchronized boolean isStale(DATA data) {
        return this.isStale() || this.getStoredData() != data;
    }

    public synchronized void runSynchronized(Runnable runnable) {
        runnable.run();
    }

    public synchronized <R, E extends Exception> R callSynchronized(CallableX<R, E> callable) throws E {
        return callable.call();
    }

    public synchronized CountDownLatch getLatchForUpdateTask() {
        return this.latch;
    }

    public synchronized void setUpdateTask(DataUpdateTask<DATA> newUpdateTask) {
        Assert.AssertNamespace.assertNotNull(newUpdateTask);
        Assert.AssertNamespace.assertTrue(this.latestUpdateTask != newUpdateTask);
        if (this.latestUpdateTask == null) {
            Assert.AssertNamespace.assertTrue(this.latch.getCount() == 0L);
            this.latch = new CountDownLatch(1);
        } else {
            Assert.AssertNamespace.assertTrue(this.latch.getCount() == 1L);
            this.latestUpdateTask.cancel();
        }
        this.latestUpdateTask = newUpdateTask;
        this.doHandleDataUpdateRequested();
    }

    protected void doHandleDataUpdateRequested() {
        for (IDataUpdateRequestedListener iDataUpdateRequestedListener : this.updateRequestedListeners.getListeners()) {
            iDataUpdateRequestedListener.dataUpdateRequested(this.getSelf());
        }
    }

    public synchronized void setNewData(DATA newData, DataUpdateTask<DATA> updateTask) {
        if (this.latestUpdateTask != updateTask) {
            Assert.AssertNamespace.assertTrue(updateTask.isCancelled());
        } else {
            try {
                this.internalSetData(newData);
                this.doHandleDataChanged();
            }
            finally {
                this.latestUpdateTask = null;
                this.latch.countDown();
            }
        }
    }

    public synchronized void cancelUpdateTask(DataUpdateTask<DATA> updateTask) {
        if (this.latestUpdateTask == updateTask) {
            this.latestUpdateTask = null;
            this.latch.countDown();
        }
    }

    protected void doHandleDataChanged() {
        ConcurrentlyDerivedData.notifyStructureChanged(this.getSelf(), this.connectedListeners);
    }

    public DataUpdateFuture asFuture() {
        return this.asFuture;
    }

    public DATA awaitUpdatedData() throws InterruptedException {
        return this.asFuture().get();
    }

    public DATA awaitUpdatedData(IOperationMonitor om) throws OperationCancellation {
        return this.asFuture().awaitData(om);
    }

    protected static <DATA> void notifyStructureChanged(DATA lockedDerivedData, ListenerListHelper<? extends IDataChangedListener<DATA>> listeners) {
        for (IDataChangedListener iDataChangedListener : listeners.getListeners()) {
            iDataChangedListener.dataChanged(lockedDerivedData);
        }
    }

    public class DataUpdateFuture
    implements SafeFuture<DATA> {
        @Override
        public boolean isDone() {
            return !ConcurrentlyDerivedData.this.isStale();
        }

        @Override
        public DATA get() throws InterruptedException {
            ConcurrentlyDerivedData.this.getLatchForUpdateTask().await();
            return ConcurrentlyDerivedData.this.data;
        }

        @Override
        public DATA get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
            boolean success = ConcurrentlyDerivedData.this.getLatchForUpdateTask().await(timeout, unit);
            if (!success) {
                throw new TimeoutException();
            }
            return ConcurrentlyDerivedData.this.data;
        }
    }

    public static abstract class DataUpdateTask<DATA>
    implements Runnable {
        protected final ConcurrentlyDerivedData<DATA, ?> derivedData;
        protected final String taskDisplayName;
        private boolean cancelled = false;
        private Thread thread;
        protected final ICancelMonitor cm = this::isCancelled;

        public DataUpdateTask(ConcurrentlyDerivedData<DATA, ?> derivedData, String taskDisplayName) {
            this.taskDisplayName = taskDisplayName;
            this.derivedData = derivedData;
        }

        public synchronized void cancel() {
            this.cancelled = true;
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }

        public synchronized boolean isCancelled() {
            return this.cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            DataUpdateTask dataUpdateTask = this;
            synchronized (dataUpdateTask) {
                if (this.cancelled) {
                    return;
                }
                this.thread = Thread.currentThread();
            }
            String originalName = this.thread.getName();
            try {
                this.thread.setName(String.valueOf(originalName) + " >> " + this.taskDisplayName);
                this.doRun();
            }
            finally {
                this.thread.setName(originalName);
            }
        }

        protected final void doRun() {
            try {
                DATA newData = this.createNewData();
                this.derivedData.setNewData(newData, this);
            }
            catch (OperationCancellation e) {
                this.derivedData.cancelUpdateTask(this);
            }
            catch (RuntimeException e) {
                this.derivedData.setNewData(null, this);
                this.handleRuntimeException(e);
            }
        }

        protected abstract void handleRuntimeException(RuntimeException var1);

        protected abstract DATA createNewData() throws OperationCancellation;
    }

    public static interface IDataChangedListener<DERIVED_DATA> {
        public void dataChanged(DERIVED_DATA var1);
    }

    public static interface IDataUpdateRequestedListener<DERIVED_DATA> {
        public void dataUpdateRequested(DERIVED_DATA var1);
    }
}

