/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils;

import java.text.MessageFormat;
import melnorme.lang.utils.SearchPathEnvOperation;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;

public class SearchPathForExecutable
extends SearchPathEnvOperation {
    protected final String exeName;
    protected Location exeLocation;

    public SearchPathForExecutable(String exeName) {
        this.exeName = MiscUtil.OS_IS_WINDOWS ? String.valueOf(exeName) + ".exe" : exeName;
    }

    public void checkIsFound() throws CommonException {
        this.check("PATH");
    }

    public void check(String envVarName) throws CommonException {
        this.searchEnvironmentVar(envVarName);
        if (this.exeLocation == null) {
            throw new CommonException(MessageFormat.format("`{0}` not found on the {1} environment var.", this.exeName, envVarName));
        }
    }

    @Override
    protected void searchPathEntry(Location path) {
        if (this.exeLocation != null) {
            return;
        }
        Location possibleLocation = path.resolve_fromValid(this.exeName);
        if (possibleLocation.toFile().exists()) {
            this.exeLocation = possibleLocation;
        }
    }

    @Override
    protected void handleWarning(String message) {
    }
}

