/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import melnorme.lang.tests.CommonToolingTest;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.Location;

public class MiscFileUtils {
    public static File getFile(File file, String ... segments) {
        String[] stringArray = segments;
        int n = segments.length;
        int n2 = 0;
        while (n2 < n) {
            String segment = stringArray[n2];
            Assert.AssertNamespace.assertTrue(!segment.contains("/") && !segment.contains("\\"));
            file = new File(file, segment);
            ++n2;
        }
        return file;
    }

    public static File getFile(String rootPath, String ... segments) {
        File file = new File(rootPath);
        return MiscFileUtils.getFile(file, segments);
    }

    public static void copyDirContentsIntoDirectory(Path sourceDir, Path destFolder) throws IOException {
        MiscFileUtils.copyDirContentsIntoDirectory(Location.create_fromValid(sourceDir), Location.create_fromValid(destFolder));
    }

    public static void copyDirContentsIntoDirectory(File sourceDir, File destFolder) throws IOException {
        MiscFileUtils.copyDirContentsIntoDirectory(sourceDir.toPath(), destFolder.toPath());
    }

    public static void copyDirContentsIntoDirectory(Location sourceDir, Location destFolder) throws IOException {
        Assert.AssertNamespace.assertTrue(sourceDir.toFile().exists());
        new FileCopyTraverser(destFolder).traverseDirectory(sourceDir);
    }

    public static void traverseFiles(File folder, boolean recurseDirs, Function<File, Void> fileVisitor) {
        MiscFileUtils.traverseFiles(folder, recurseDirs, fileVisitor, null);
    }

    public static void traverseFiles(File folder, boolean recurseDirs, Function<File, Void> fileVisitor, FilenameFilter filter) {
        Assert.AssertNamespace.assertTrue(folder.exists() && folder.isDirectory());
        File[] children = folder.listFiles(filter);
        Assert.AssertNamespace.assertNotNull(children);
        File[] fileArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.isDirectory() && recurseDirs) {
                fileVisitor.apply(file);
                MiscFileUtils.traverseFiles(file, recurseDirs, fileVisitor, filter);
            } else {
                fileVisitor.apply(file);
            }
            ++n2;
        }
    }

    public static void unzipFile(File zipFile, File parentDir) throws IOException {
        MiscFileUtils.unzipFile(zipFile, parentDir, CommonToolingTest.testsLogger);
    }

    public static void unzipFile(File zipFile, File parentDir, PrintStream logger) throws ZipException, IOException {
        logger.println("== Unzipping: " + zipFile);
        try (ZipFile zip = new ZipFile(zipFile);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryTargetFile = new File(parentDir, entry.getName());
                if (entry.isDirectory()) {
                    entryTargetFile.mkdirs();
                    continue;
                }
                entryTargetFile.getParentFile().mkdirs();
                Path destPath = entryTargetFile.toPath();
                logger.println("Unzipped: " + entry);
                logger.println("  to: " + destPath);
                Files.copy(zip.getInputStream(entry), destPath, new CopyOption[0]);
            }
        }
    }

    public static final class FileCopyTraverser
    extends FileTraverser {
        protected final Location destFolder;

        private FileCopyTraverser(Location destFolder) {
            this.destFolder = destFolder;
        }

        @Override
        protected void visitFile(File file, Path relativePath) throws IOException {
            Path targetPath = this.destFolder.toPath().resolve(relativePath);
            File targetPathParent = new File(targetPath.toString()).getParentFile();
            targetPathParent.mkdirs();
            Assert.AssertNamespace.assertTrue(targetPathParent.exists());
            Files.copy(file.toPath(), targetPath, new CopyOption[0]);
        }
    }

    public static class FileTraverser {
        protected Location rootDir;

        public void traverseDirectory(Location dirLoc) throws IOException {
            File dir = dirLoc.toFile();
            Assert.AssertNamespace.assertTrue(dir.exists() && dir.isDirectory());
            this.rootDir = dirLoc;
            this.traverseFileOrDir(dir);
        }

        public void traverseFileOrDir(File file) throws IOException {
            Assert.AssertNamespace.assertTrue(file.exists());
            if (file.isDirectory()) {
                this.visitDirectory(file);
            } else {
                Path relativePath = this.rootDir == null ? null : this.rootDir.toPath().relativize(file.toPath());
                this.visitFile(file, relativePath);
            }
        }

        protected void visitDirectory(File dir) throws IOException {
            File[] children = dir.listFiles(this.getDefaultDirFilter());
            Assert.AssertNamespace.assertTrue(children != null);
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                this.traverseFileOrDir(file);
                ++n2;
            }
        }

        protected FilenameFilter getDefaultDirFilter() {
            return null;
        }

        protected void visitFile(File file, Path relativePath) throws IOException {
        }
    }
}

