/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.Location;

public class FileModificationDetectionHelper {
    protected final Location fileLocation;
    protected BasicFileAttributes fileSyncAttributes;

    public FileModificationDetectionHelper(Location fileLocation) {
        this.fileLocation = Assert.AssertNamespace.assertNotNull(fileLocation);
    }

    public Path getFilePath() {
        return this.fileLocation.getPath();
    }

    public void markRead() throws IOException {
        this.fileSyncAttributes = Files.readAttributes(this.getFilePath(), BasicFileAttributes.class, new LinkOption[0]);
    }

    public void markStale() {
        this.fileSyncAttributes = null;
    }

    public boolean isModifiedSinceLastRead() {
        BasicFileAttributes newAttributes;
        try {
            newAttributes = Files.readAttributes(this.getFilePath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (IOException e) {
            return true;
        }
        return this.hasBeenModified(this.fileSyncAttributes, newAttributes);
    }

    protected boolean hasBeenModified(BasicFileAttributes originalAttributes, BasicFileAttributes newAttributes) {
        if (newAttributes.lastModifiedTime().toMillis() > System.currentTimeMillis()) {
            this.handleWarning_ModifiedTimeInTheFuture(newAttributes.lastModifiedTime());
        }
        return originalAttributes == null || originalAttributes.lastModifiedTime().toMillis() != newAttributes.lastModifiedTime().toMillis() || originalAttributes.size() != newAttributes.size();
    }

    protected void handleWarning_ModifiedTimeInTheFuture(FileTime lastModifiedTime) {
    }
}

