/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.utils;

import melnorme.lang.utils.parse.LexingUtils;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;

public class ArgumentsParser {
    protected final char singleQuote;
    protected final char doubeQuote;
    protected final char escapeChar;

    public ArgumentsParser() {
        this('\'', '\"', '\\');
    }

    public static Indexable<String> parse(String argsSource) {
        return new ArgumentsParser().parseFrom(argsSource);
    }

    public ArgumentsParser(char singleQuote, char doubeQuote, char escapeChar) {
        this.singleQuote = singleQuote;
        this.doubeQuote = doubeQuote;
        this.escapeChar = escapeChar;
    }

    public Indexable<String> parseFrom(String source) {
        StringCharSource charSource = new StringCharSource(source);
        return this.parseArguments(charSource, new ArrayList2<String>());
    }

    public ArrayList2<String> parseArguments(StringCharSource source, ArrayList2<String> args) {
        while (true) {
            LexingUtils.skipWhitespace(source);
            if (!source.hasCharAhead()) {
                return args;
            }
            String arg = this.parseArgument(source);
            Assert.AssertNamespace.assertNotNull(arg);
            args.add(arg);
        }
    }

    protected String parseArgument(StringCharSource source) {
        if (source.tryConsume(this.singleQuote)) {
            return LexingUtils.consumeUntilDelimiterOrEOS(source, this.singleQuote, this.escapeChar);
        }
        if (source.tryConsume(this.doubeQuote)) {
            return LexingUtils.consumeUntilDelimiterOrEOS(source, this.doubeQuote, this.escapeChar);
        }
        return source.consumeUntil(reader -> Character.isWhitespace(reader.lookahead()));
    }
}

