/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.toolchain.ops;

import java.util.Optional;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.common.SourceLineColumnRange;
import melnorme.lang.tooling.parser.SourceLinesInfo;
import melnorme.lang.tooling.toolchain.ops.SourceLocation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.FileUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;

public class SourceOpContext {
    public static final String MSG_NoFileLocationForThisOperation = "No file location for this operation";
    protected final Optional<Location> fileLocation;
    protected final String source;
    protected final int offset;
    protected final SourceRange selection;
    protected final boolean isDirty;
    private SourceLinesInfo sourceLinesInfo;

    public SourceOpContext(Optional<Location> fileLocation, int offset, String source, boolean isDirty) {
        this(fileLocation, offset, new SourceRange(offset, 0), source, isDirty);
    }

    public SourceOpContext(Optional<Location> fileLocation, int offset, SourceRange selection, String source, boolean isDirty) {
        this.fileLocation = fileLocation;
        this.offset = offset;
        this.selection = Assert.AssertNamespace.assertNotNull(selection);
        this.source = Assert.AssertNamespace.assertNotNull(source);
        this.isDirty = isDirty;
    }

    public int getOffset() {
        return this.offset;
    }

    public SourceRange getSelection() {
        return this.selection;
    }

    public Optional<Location> getOptionalFileLocation() {
        return this.fileLocation;
    }

    public Location getFileLocation() throws CommonException {
        if (this.fileLocation.isPresent()) {
            return this.fileLocation.get();
        }
        throw new CommonException(MSG_NoFileLocationForThisOperation);
    }

    public String getSource() {
        return this.source;
    }

    public SourceRange getOperationRange() {
        return this.selection;
    }

    public boolean isDocumentDirty() {
        return this.isDirty;
    }

    public synchronized SourceLinesInfo getSourceLinesInfo() {
        if (this.sourceLinesInfo == null) {
            this.sourceLinesInfo = new SourceLinesInfo(this.source);
        }
        return this.sourceLinesInfo;
    }

    public int getInvocationLine_0() throws CommonException {
        return this.getSourceLinesInfo().getLineForOffset(this.getOffset());
    }

    public int getInvocationColumn_0() throws CommonException {
        return this.getSourceLinesInfo().getColumnForOffset(this.getOffset());
    }

    public String getSourceFor(Location location) throws CommonException {
        if (this.fileLocation.isPresent() && CoreUtil.areEqual(location, this.fileLocation.get())) {
            return this.source;
        }
        return FileUtil.readFileContents(location, StringUtil.UTF8);
    }

    public int getOffsetFor(SourceLocation findDefResult) throws CommonException {
        String fileContents = this.getSourceFor(findDefResult.getFileLocation());
        SourceLinesInfo linesInfo = new SourceLinesInfo(fileContents);
        SourceLineColumnRange sourceLCRange = findDefResult.getSourceRange();
        return linesInfo.getOffsetForLine(sourceLCRange.getValidLineIndex()) + sourceLCRange.getValidColumnIndex();
    }
}

