/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.toolchain.ops;

import java.nio.file.Path;
import java.util.ArrayList;
import melnorme.lang.tooling.common.SourceLineColumnRange;
import melnorme.lang.tooling.common.ToolSourceMessage;
import melnorme.lang.tooling.toolchain.ops.AbstractToolResultParser;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.lang.tooling.toolchain.ops.ToolOutputParseHelper;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.IByteSequence;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.process.ExternalProcessHelper;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusLevel;

public abstract class BuildOutputParser2
extends AbstractToolResultParser<ArrayList<ToolSourceMessage>>
implements ToolOutputParseHelper {
    protected ArrayList2<ToolSourceMessage> buildMessages;

    public ArrayList2<ToolSourceMessage> getBuildMessages() {
        return this.buildMessages;
    }

    @Override
    protected String getToolName() {
        return "Build tool";
    }

    @Override
    public ArrayList<ToolSourceMessage> doParseResult(ExternalProcessHelper.ExternalProcessResult result) throws CommonException {
        try {
            this.validateExitCode(result);
            return this.parseOutput(this.getOutputFromProcessResult(result).toString(StringUtil.UTF8));
        }
        catch (OperationSoftFailure e) {
            throw new CommonException(e.getMessage());
        }
    }

    protected IByteSequence getOutputFromProcessResult(ExternalProcessHelper.ExternalProcessResult result) {
        return result.getStdOutBytes();
    }

    @Override
    public final ArrayList<ToolSourceMessage> parseOutput(String output) throws CommonException {
        return this.parseOutput(new StringCharSource(output));
    }

    @Override
    public ArrayList<ToolSourceMessage> parseOutput(StringCharSource output) throws CommonException {
        this.buildMessages = new ArrayList2();
        while (output.hasCharAhead()) {
            this.doParseToolMessage(output);
        }
        return this.buildMessages;
    }

    protected void doParseToolMessage(StringCharSource output) {
        try {
            ToolMessageData toolMessage = this.parseMessageData(output);
            if (toolMessage != null) {
                this.addBuildMessage(toolMessage);
            }
        }
        catch (CommonException ce) {
            this.handleMessageParseError(ce);
        }
    }

    protected void addBuildMessage(ToolMessageData toolMessage) throws CommonException {
        this.buildMessages.add(this.createMessage(toolMessage));
    }

    protected abstract ToolMessageData parseMessageData(StringCharSource var1) throws CommonException;

    protected final void handleMessageParseError(CommonException ce) {
        this.handleParseError(ce);
    }

    protected abstract void handleParseError(CommonException var1);

    protected CommonException createUnknownLineSyntaxError(String line) {
        return new CommonException("Unknown error line syntax: " + line);
    }

    protected ToolSourceMessage createMessage(ToolMessageData msgdata) throws CommonException {
        Path filePath = this.parsePath(msgdata.pathString).normalize();
        int lineNo = this.parsePositiveInt(msgdata.lineString);
        int column = this.parseOptionalPositiveInt(StringUtil.emptyAsNull(msgdata.columnString));
        int endline = this.parseOptionalPositiveInt(msgdata.endLineString);
        int endColumn = this.parseOptionalPositiveInt(msgdata.endColumnString);
        Severity severity = Severity.fromString(msgdata.messageTypeString);
        Assert.AssertNamespace.assertNotNull(severity);
        SourceLineColumnRange sourceRange = new SourceLineColumnRange(lineNo, column, endline, endColumn);
        return new ToolSourceMessage(filePath, sourceRange, severity, msgdata.messageText);
    }

    protected StatusLevel parseMessageKind(String messageTypeString) throws CommonException {
        return StatusLevel.fromString(messageTypeString);
    }

    protected int parseOptionalPositiveInt(String columnStr) throws CommonException {
        return columnStr == null ? -1 : this.parsePositiveInt(columnStr);
    }

    public static class ToolMessageData {
        public String pathString;
        public String lineString;
        public String columnString;
        public String endLineString;
        public String endColumnString;
        public String messageTypeString;
        public String sourceBeforeMessageText;
        public String messageText;
    }
}

