/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.toolchain.ops;

import melnorme.lang.tooling.ToolingMessages;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.lang.tooling.toolchain.ops.ToolResponse;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.process.ExternalProcessHelper;

public abstract class AbstractToolResultParser<RESULT> {
    public ToolResponse<RESULT> parseResult(ExternalProcessHelper.ExternalProcessResult result) {
        try {
            return new ToolResponse<RESULT>(this.doParseResult(result));
        }
        catch (OperationSoftFailure e) {
            return ToolResponse.newError(e.getMessage());
        }
        catch (CommonException e) {
            return ToolResponse.newError(e.getMultiLineRender());
        }
    }

    public RESULT doParseResult(ExternalProcessHelper.ExternalProcessResult result) throws CommonException, OperationSoftFailure {
        this.validateExitCode(result);
        return this.parseOutput(result.getStdOutBytes().toString(StringUtil.UTF8));
    }

    protected void validateExitCode(ExternalProcessHelper.ExternalProcessResult result) throws CommonException, OperationSoftFailure {
        if (result.exitValue != 0) {
            this.handleNonZeroExitCode(result);
        }
    }

    protected void handleNonZeroExitCode(ExternalProcessHelper.ExternalProcessResult result) throws CommonException, OperationSoftFailure {
        throw new CommonException(ToolingMessages.PROCESS_CompletedWithNonZeroValue(this.getToolName(), result.exitValue));
    }

    protected abstract String getToolName() throws CommonException;

    public RESULT parseOutput(String output) throws CommonException, OperationSoftFailure {
        return this.parseOutput(new StringCharSource(output));
    }

    public abstract RESULT parseOutput(StringCharSource var1) throws CommonException, OperationSoftFailure;
}

