/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.structure;

import melnorme.lang.tooling.EAttributeFlag;
import melnorme.lang.tooling.ElementAttributes;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.structure.AbstractStructureContainer;
import melnorme.lang.tooling.structure.ISourceFileStructure;
import melnorme.lang.tooling.structure.IStructureElement;
import melnorme.lang.tooling.structure.IStructureElementContainer;
import melnorme.lang.tooling.structure.StructureElement;
import melnorme.lang.tooling.structure.StructureElementKind;
import melnorme.lang.tooling.structure.StructureElementPrinter;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;
import melnorme.utilbox.misc.StringUtil;

abstract class StructureElement_Default
extends AbstractStructureContainer
implements IStructureElement {
    protected final String name;
    protected final SourceRange sourceRange;
    protected final SourceRange nameSourceRange2;
    protected final StructureElementKind elementKind;
    protected final ElementAttributes elementAttributes;
    protected final String type;
    protected IStructureElementContainer parent;

    public StructureElement_Default(String name, SourceRange nameSourceRange, SourceRange sourceRange, StructureElementKind elementKind, ElementAttributes elementAttributes, String type, Indexable<StructureElement> children) {
        super(children);
        this.name = Assert.AssertNamespace.assertNotNull(name);
        this.sourceRange = Assert.AssertNamespace.assertNotNull(sourceRange);
        this.nameSourceRange2 = nameSourceRange;
        this.elementKind = Assert.AssertNamespace.assertNotNull(elementKind);
        this.elementAttributes = elementAttributes == null ? new ElementAttributes(null, new EAttributeFlag[0]) : elementAttributes;
        this.type = type;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StructureElement)) {
            return false;
        }
        StructureElement other = (StructureElement)obj;
        return CoreUtil.areEqual(this.name, other.name) && CoreUtil.areEqual(this.nameSourceRange2, other.nameSourceRange2) && CoreUtil.areEqual(this.sourceRange, other.sourceRange) && CoreUtil.areEqual((Object)this.elementKind, (Object)other.elementKind) && CoreUtil.areEqual(this.elementAttributes, other.elementAttributes) && CoreUtil.areEqual(this.type, other.type) && CoreUtil.areEqual(this.children, other.children);
    }

    public int hashCode() {
        return HashcodeUtil.combinedHashCode(new Object[]{this.name, this.sourceRange, this.elementKind, this.elementAttributes, this.children.size()});
    }

    protected String toStringNode() {
        return "ELEM " + this.name + this.sourceRange + " " + (Object)((Object)this.elementKind) + StringUtil.prefixStr(" : ", this.type) + " " + this.elementAttributes;
    }

    public StructureElement cloneSubTree() {
        return new StructureElement(this.name, this.nameSourceRange2, this.sourceRange, this.elementKind, this.elementAttributes, this.type, StructureElement_Default.cloneSubTree(this.children));
    }

    public static ArrayList2<StructureElement> cloneSubTree(Indexable<StructureElement> elements) {
        ArrayList2<StructureElement> clonedElements = new ArrayList2<StructureElement>(elements.size());
        for (StructureElement child : elements) {
            clonedElements.add(child.cloneSubTree());
        }
        return clonedElements;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SourceRange getSourceRange() {
        return this.sourceRange;
    }

    @Override
    public SourceRange getNameSourceRange2() {
        return this.nameSourceRange2;
    }

    @Override
    public StructureElementKind getKind() {
        return this.elementKind;
    }

    @Override
    public ElementAttributes getAttributes() {
        return this.elementAttributes;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public IStructureElementContainer getParent() {
        return this.parent;
    }

    @Override
    public void setParent(IStructureElementContainer parent) {
        Assert.AssertNamespace.assertNotNull(parent);
        Assert.AssertNamespace.assertTrue(this.parent == null);
        this.parent = parent;
    }

    @Override
    public ISourceFileStructure getContainingFileStructure() {
        return StructureElement_Default.getFileStructure(this);
    }

    public static ISourceFileStructure getFileStructure(IStructureElement element) {
        IStructureElementContainer parent = element.getParent();
        if (parent instanceof ISourceFileStructure) {
            return (ISourceFileStructure)parent;
        }
        if (parent instanceof IStructureElement) {
            return StructureElement_Default.getFileStructure((IStructureElement)parent);
        }
        return null;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean printChildren) {
        if (printChildren) {
            return new StructureElementPrinter().printElement((StructureElement)this);
        }
        return this.toStringNode();
    }
}

