/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.structure;

import melnorme.lang.tooling.AbstractKindVisitor;
import melnorme.utilbox.core.Assert;

public enum StructureElementKind {
    VARIABLE,
    CONST,
    FUNCTION,
    METHOD,
    INTERFACE,
    STRUCT,
    TYPE_DECL,
    MODULEDEC;


    public <RET> RET switchOnKind(StructureElementKindVisitor<RET> visitor) {
        return StructureElementKind.switchOnKind(this, visitor);
    }

    public static <RET> RET switchOnKind(StructureElementKind kind, StructureElementKindVisitor<RET> visitor) {
        switch (kind) {
            case VARIABLE: {
                return visitor.visitVariable();
            }
            case CONST: {
                return visitor.visitConst();
            }
            case FUNCTION: {
                return visitor.visitFunction();
            }
            case METHOD: {
                return visitor.visitMethod();
            }
            case INTERFACE: {
                return visitor.visitInterface();
            }
            case STRUCT: {
                return visitor.visitStruct();
            }
            case TYPE_DECL: {
                return visitor.visitTypeDecl();
            }
            case MODULEDEC: {
                return visitor.visitModule();
            }
        }
        throw Assert.AssertNamespace.assertUnreachable();
    }

    public static interface StructureElementKindVisitor<RET>
    extends AbstractKindVisitor<RET> {
        public RET visitMethod();

        public RET visitConst();

        public RET visitTypeDecl();
    }
}

