/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.structure;

import melnorme.lang.tooling.common.ParserError;
import melnorme.lang.tooling.structure.AbstractStructureContainer;
import melnorme.lang.tooling.structure.ISourceFileStructure;
import melnorme.lang.tooling.structure.IStructureElementContainer;
import melnorme.lang.tooling.structure.SourceFileStructure;
import melnorme.lang.tooling.structure.StructureElement;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;
import melnorme.utilbox.misc.Location;

public abstract class SourceFileStructure_Default
extends AbstractStructureContainer
implements ISourceFileStructure {
    protected final Location location;
    protected final Indexable<ParserError> parserProblems;

    public SourceFileStructure_Default(Location location, Indexable<StructureElement> children, Indexable<ParserError> parserProblems) {
        super(children);
        this.location = location;
        this.parserProblems = CoreUtil.nullToEmpty(parserProblems);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SourceFileStructure)) {
            return false;
        }
        SourceFileStructure other = (SourceFileStructure)obj;
        return CoreUtil.areEqual(this.location, other.location) && CoreUtil.areEqual(this.children, other.children);
    }

    public int hashCode() {
        return HashcodeUtil.combinedHashCode(this.location, this.children);
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + (this.location == null ? "" : " " + this.location);
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public String getModuleName() {
        return this.location == null ? null : this.location.getPath().getFileName().toString();
    }

    public Indexable<ParserError> getParserProblems() {
        return this.parserProblems;
    }

    public StructureElement getStructureElementAt(int offset) {
        return new StructureElementFinderByOffset(offset).findInnerMost(this);
    }

    public static class StructureElementFinderByOffset {
        protected final int offset;
        protected StructureElement pickedElement;

        public StructureElementFinderByOffset(int offset) {
            this.offset = offset;
        }

        public StructureElement findInnerMost(IStructureElementContainer container) {
            this.visitContainer(container);
            return this.pickedElement;
        }

        protected void visitContainer(IStructureElementContainer container) {
            Assert.AssertNamespace.assertNotNull(container);
            for (StructureElement childElement : container.getChildren()) {
                if (childElement.getSourceRange().inclusiveContains(this.offset)) {
                    if (this.pickedElement == null) {
                        this.pickedElement = childElement;
                    } else if (this.pickedElement.getSourceRange().inclusiveContains(childElement.getSourceRange())) {
                        this.pickedElement = childElement;
                    }
                }
                this.visitContainer(childElement);
            }
        }
    }
}

