/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.parser.lexer;

import melnorme.lang.tooling.parser.lexer.ILexingRule2;
import melnorme.lang.utils.parse.ICharacterReader;
import melnorme.lang.utils.parse.LexingUtils;
import melnorme.utilbox.collections.HashMap2;

public class WordLexerRule<TOKEN>
implements ILexingRule2<TOKEN> {
    protected final TOKEN whitespaceToken;
    protected final TOKEN defaultWordToken;
    protected final HashMap2<String, TOKEN> tokenMap = new HashMap2();

    public WordLexerRule(TOKEN whitespaceToken, TOKEN defaultWordToken) {
        this.whitespaceToken = whitespaceToken;
        this.defaultWordToken = defaultWordToken;
    }

    public void addKeywords(TOKEN token, String[] keywords) {
        String[] stringArray = keywords;
        int n = keywords.length;
        int n2 = 0;
        while (n2 < n) {
            String keyword = stringArray[n2];
            this.addWord(keyword, token);
            ++n2;
        }
    }

    public void addWord(String keyword, TOKEN token) {
        this.tokenMap.put(keyword, token);
    }

    @Override
    public TOKEN doEvaluateToken(ICharacterReader reader) {
        if (LexingUtils.skipWhitespace(reader) > 0) {
            return this.whitespaceToken;
        }
        String word = LexingUtils.readJavaIdentifier(reader);
        if (word.isEmpty()) {
            return null;
        }
        Object keywordToken = this.tokenMap.get(word);
        return (TOKEN)(keywordToken == null ? this.defaultWordToken : keywordToken);
    }
}

