/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.parser.lexer;

import melnorme.lang.tooling.parser.lexer.CharacterLexingRule;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.core.Assert;
import org.junit.Test;

public class CharacterLexingRule_Test {
    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        CharacterLexingRule rule = new CharacterLexingRule();
        this.testRule(rule, "'a'", 3);
        this.testRule(rule, "'", 0);
        this.testRule(rule, "''", 0);
        this.testRule(rule, "'''", 0);
        this.testRule(rule, "'a", 0);
        this.testRule(rule, "'ab'", 0);
        this.testRule(rule, "'\\''", 4);
        this.testRule(rule, "'\\\\'", 4);
        this.testRule(rule, "'\\t'", 4);
        this.testRule(rule, "'\\%'", 0);
        this.testRule(rule, "'\\xA0'", 6);
        this.testRule(rule, "'\\x1b'", 6);
        this.testRule(rule, "'\\x1g'", 0);
        this.testRule(rule, "'\\xg0'", 0);
        this.testRule(rule, "'\\xu'", 0);
        this.testRule(rule, "'\\uA0'", 6);
        this.testRule(rule, "'\\u'", 4);
        this.testRule(rule, "'\\u '", 0);
        this.testRule(rule, "'\\u\\n'", 0);
        this.testRule(rule, "'\\u", 0);
    }

    protected void testRule(CharacterLexingRule rule, String source, int expectedMatchLength) {
        StringCharSource reader = new StringCharSource(source);
        boolean expectedMatches = expectedMatchLength > 0;
        Assert.AssertNamespace.assertTrue(rule.tryMatch(reader) == expectedMatches);
        if (expectedMatches) {
            Assert.AssertNamespace.assertTrue(reader.getReadPosition() == expectedMatchLength);
        }
    }
}

