/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.parser.lexer;

import melnorme.lang.tooling.parser.lexer.IPredicateLexingRule;
import melnorme.lang.utils.parse.ICharacterReader;
import melnorme.lang.utils.parse.LexingUtils;

public class CharacterLexingRule
extends LexingUtils
implements IPredicateLexingRule {
    protected static char[] COMMON_ESCAPES = new char[]{'\\', 'n', 'r', 't', '0'};

    @Override
    public boolean doEvaluate(ICharacterReader reader) {
        if (!this.consumeStart(reader)) {
            return false;
        }
        if (!this.consumeBody(reader)) {
            return false;
        }
        return this.consumeEnd(reader);
    }

    protected boolean consumeStart(ICharacterReader reader) {
        return reader.tryConsume('\'');
    }

    protected boolean consumeBody(ICharacterReader reader) {
        if (reader.tryConsume('\\')) {
            return reader.tryConsume('\'') || reader.tryConsume('\"') || this.consumeCommonEscape(reader) || this.consumeUnicodeEscapeSequence(reader);
        }
        if (reader.lookaheadIsEOS() || reader.lookahead() == 39) {
            return false;
        }
        if (reader.lookahead() == 0) {
            return false;
        }
        return reader.consumeAny();
    }

    protected boolean consumeEnd(ICharacterReader reader) {
        return reader.tryConsume('\'');
    }

    protected boolean consumeCommonEscape(ICharacterReader reader) {
        char[] cArray = COMMON_ESCAPES;
        int n = COMMON_ESCAPES.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (reader.tryConsume(ch)) {
                return true;
            }
            ++n2;
        }
        return this.consumeHexEscapeSequence(reader);
    }

    protected boolean consumeHexEscapeSequence(ICharacterReader reader) {
        if (reader.lookahead(0) == 120 && CharacterLexingRule.isHexDigit(reader.lookahead(1)) && CharacterLexingRule.isHexDigit(reader.lookahead(2))) {
            reader.consume(3);
            return true;
        }
        return false;
    }

    protected boolean consumeUnicodeEscapeSequence(ICharacterReader reader) {
        if (reader.tryConsume('u')) {
            int la;
            while ((la = reader.lookahead()) == 123 || la == 125 || CharacterLexingRule.isHexDigit(la)) {
                reader.consume();
            }
            return true;
        }
        return false;
    }

    public static boolean isHexDigit(int ch) {
        if (ch >= 48 && ch <= 57) {
            return true;
        }
        return ch >= 97 && ch <= 102 || ch >= 65 && ch <= 70;
    }
}

