/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.parser;

import melnorme.lang.tooling.parser.TextBlocksReader;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.tests.CommonTestUtils;
import org.junit.Test;

public class TextBlocksReader_Test
extends CommonTestUtils {
    protected TextBlocksReader createReader(String source) {
        return new TextBlocksReader(new StringCharSource(TextBlocksReader_Test.str(source)));
    }

    public static String str(String str) {
        return str.replace("|", "\"");
    }

    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        TextBlocksReader.TextBlocksSubReader subReader2;
        TextBlocksReader_Test.assertEquals(this.createReader(" blah").consumeText(), "blah");
        TextBlocksReader_Test.assertEquals(this.createReader(" ||").consumeText(), "");
        TextBlocksReader_Test.assertEquals(this.createReader(" ||||").consumeText(), "");
        TextBlocksReader_Test.assertEquals(this.createReader(" |\\\\|").consumeText(), "\\");
        TextBlocksReader_Test.assertEquals(this.createReader(" ||blah").consumeText(), "blah");
        String seqA = "blah 1.0 |--\\|--| aa.-=+\"xx\\\"xx\"cc";
        this.testReaderBasicSequenceA(this.createReader("blah 1.0 |--\\|--| aa.-=+\"xx\\\"xx\"cc"));
        TextBlocksReader reader = this.createReader(" {blah}{blah|}|}{xxx{ccc}}");
        Throwable throwable = null;
        Object var4_7 = null;
        try {
            subReader2 = reader.enterBlock();
            try {
                TextBlocksReader_Test.assertEquals(subReader2.consumeText(), "blah");
            }
            finally {
                if (subReader2 != null) {
                    subReader2.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        Assert.AssertNamespace.assertTrue(reader.charSource.lookaheadChar() == '{');
        throwable = null;
        var4_7 = null;
        try {
            subReader2 = reader.enterBlock();
            try {
                TextBlocksReader_Test.assertEquals(subReader2.consumeText(), "blah}");
            }
            finally {
                if (subReader2 != null) {
                    subReader2.close();
                }
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
            } else if (throwable != throwable3) {
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
        throwable = null;
        var4_7 = null;
        try {
            subReader2 = reader.enterBlock();
            try {
                TextBlocksReader_Test.assertEquals(subReader2.consumeText(), "xxx");
                Throwable throwable4 = null;
                Object var7_14 = null;
                try (TextBlocksReader.TextBlocksSubReader subReader22 = reader.enterBlock();){
                    TextBlocksReader_Test.assertEquals(subReader22.consumeText(), "ccc");
                }
                catch (Throwable throwable5) {
                    if (throwable4 == null) {
                        throwable4 = throwable5;
                    } else if (throwable4 != throwable5) {
                        throwable4.addSuppressed(throwable5);
                    }
                    throw throwable4;
                }
            }
            finally {
                if (subReader2 != null) {
                    subReader2.close();
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
        reader = this.createReader(" {blah 1.0 |--\\|--| aa.-=+\"xx\\\"xx\"cc} blah 1.0 |--\\|--| aa.-=+\"xx\\\"xx\"cc { blah 1.0 |--\\|--| aa.-=+\"xx\\\"xx\"cc } ");
        reader.consumeBlock(subReader -> this.testReaderBasicSequenceA(subReader));
        this.testReaderBasicSequenceA(reader);
        reader.consumeBlock(subReader -> this.testReaderBasicSequenceA(subReader));
        Assert.AssertNamespace.assertTrue(reader.tokenAhead() == TextBlocksReader.TokenKind.EOS);
        reader = this.createReader(" asfd|}| aaa {} bbb {blah 1.0 |--\\|--| aa.-=+\"xx\\\"xx\"cc { axdfxd } } ccc");
        reader.skipNextElement();
        TextBlocksReader_Test.assertEquals(reader.consumeText(), "aaa");
        reader.skipNextElement();
        TextBlocksReader_Test.assertEquals(reader.consumeText(), "bbb");
        reader.skipNextElement();
        TextBlocksReader_Test.assertEquals(reader.consumeText(), "ccc");
        this.testErrorCases();
    }

    protected Void testReaderBasicSequenceA(TextBlocksReader reader) throws CommonException {
        Assert.AssertNamespace.assertTrue(reader.peekTokenStart() == 98);
        reader.expectText("blah");
        reader.expectText("1.0");
        reader.expectText("--\"--");
        reader.expectText("aa.-=+xx\"xxcc");
        Assert.AssertNamespace.assertTrue(this.createReader("").tokenAhead() == TextBlocksReader.TokenKind.EOS);
        Assert.AssertNamespace.assertTrue(this.createReader("  ").tokenAhead() == TextBlocksReader.TokenKind.EOS);
        Assert.AssertNamespace.assertTrue(this.createReader(" }").tokenAhead() == TextBlocksReader.TokenKind.EOS);
        return null;
    }

    protected void testErrorCases() {
        TextBlocksReader_Test.verifyThrows(() -> {
            String string = this.createReader("  {").consumeText();
        }, null, "Expected text, found `{`.");
        TextBlocksReader_Test.verifyThrows(() -> {
            String string = this.createReader("  \"abc").consumeText();
        }, null, "Unterminated text `abc`.");
        TextBlocksReader_Test.verifyThrows(() -> this.createReader("  blah").expectText("xxx"), null, "Expected text `xxx`, found text `blah`.");
        TextBlocksReader_Test.verifyThrows(() -> this.createReader("  ( )").expectText("xxx"), null, "Expected text `xxx`, found `(`.");
        TextBlocksReader_Test.verifyThrows(() -> {
            Throwable throwable = null;
            Object var2_3 = null;
            try {
                TextBlocksReader.TextBlocksSubReader subReader = this.createReader(" (  ").enterBlock();
                try {
                    throw new CommonException("foo");
                }
                catch (Throwable throwable2) {
                    if (subReader != null) {
                        subReader.close();
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }, null, "foo");
        TextBlocksReader_Test.verifyThrows(() -> {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                TextBlocksReader.TextBlocksSubReader subReader = this.createReader(" { ) ").enterBlock();
                if (subReader != null) {
                    subReader.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, null, "Expected BLOCK_CLOSE `}`, found `)`");
        TextBlocksReader_Test.verifyThrows(() -> {
            Throwable throwable = null;
            Object var2_2 = null;
            try {
                TextBlocksReader.TextBlocksSubReader subReader = this.createReader(" {  ").enterBlock();
                if (subReader != null) {
                    subReader.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }, null, "Expected BLOCK_CLOSE `}`, found EOS");
    }
}

