/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.parser;

import java.text.MessageFormat;
import melnorme.lang.utils.parse.BasicCharSource_CommonExceptionAdapter;
import melnorme.lang.utils.parse.IBasicCharSource;
import melnorme.lang.utils.parse.LexingUtils;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.ArrayUtil;

public class TextBlocksReader {
    protected final BasicCharSource_CommonExceptionAdapter charSource;
    protected final char[] blockOpens;
    protected final char[] blockCloses;
    protected String lastValue;
    protected TokenKind lastKind;

    public TextBlocksReader(IBasicCharSource<? extends Exception> charSource) {
        this(charSource, CoreUtil.arrayC('{', '(', '['), CoreUtil.arrayC('}', ')', ']'));
    }

    public TextBlocksReader(IBasicCharSource<? extends Exception> charSource, char[] blockOpens, char[] blockCloses) {
        this.charSource = new BasicCharSource_CommonExceptionAdapter(Assert.AssertNamespace.assertNotNull(charSource));
        this.blockOpens = Assert.AssertNamespace.assertNotNull(blockOpens);
        this.blockCloses = Assert.AssertNamespace.assertNotNull(blockCloses);
        Assert.AssertNamespace.assertTrue(blockOpens.length == blockCloses.length);
    }

    public int peekTokenStart() throws CommonException {
        LexingUtils.skipWhitespace(this.charSource);
        return this.charSource.lookahead();
    }

    protected char consumeChar() throws CommonException {
        this.lastKind = null;
        this.lastValue = null;
        return this.charSource.consume();
    }

    public String setTokenResult(String value, TokenKind kind) {
        this.lastValue = value;
        this.lastKind = kind;
        return value;
    }

    public TokenKind tokenAhead() throws CommonException {
        int tokenStartChar = this.peekTokenStart();
        if (tokenStartChar == -1) {
            return TokenKind.EOS;
        }
        char ch = (char)tokenStartChar;
        if (this.charIsBlockOpen(ch)) {
            return TokenKind.BLOCK_OPEN;
        }
        if (this.charIsBlockClose(ch)) {
            return TokenKind.EOS;
        }
        return TokenKind.TEXT;
    }

    protected boolean charIsBlockOpen(char ch) {
        return ArrayUtil.indexOf(this.blockOpens, ch) != -1;
    }

    protected boolean charIsBlockClose(char ch) {
        return ArrayUtil.indexOf(this.blockCloses, ch) != -1;
    }

    public boolean aheadIsEnd() throws CommonException {
        return this.tokenAhead() == TokenKind.EOS;
    }

    public boolean aheadIsBlockStart() throws CommonException {
        return this.tokenAhead() == TokenKind.BLOCK_OPEN;
    }

    public boolean aheadIsText() throws CommonException {
        return this.tokenAhead() == TokenKind.TEXT;
    }

    public String consumeText() throws CommonException {
        if (this.tokenAhead() != TokenKind.TEXT) {
            throw this.createParseException("Expected text, {0}.", this.errorAtTokenStart());
        }
        return this.parseTextValue();
    }

    protected String parseTextValue() throws CommonException {
        this.peekTokenStart();
        StringBuilder sb = new StringBuilder();
        while (this.charSource.hasCharAhead()) {
            char ahead = this.charSource.lookaheadChar();
            if (Character.isWhitespace(ahead) || this.charIsBlockClose(ahead) || this.charIsBlockOpen(ahead)) break;
            char ch = this.consumeChar();
            if (ch == '\"') {
                boolean isEOS = LexingUtils.consumeUntilDelimiter_intoStringBuilder(this.charSource, '\"', '\\', sb);
                if (!isEOS) continue;
                throw this.createParseException("Unterminated text `{0}`.", sb.toString());
            }
            sb.append(ch);
        }
        return this.setTokenResult(sb.toString(), TokenKind.TEXT);
    }

    public TextBlocksSubReader enterBlock() throws CommonException {
        if (this.tokenAhead() != TokenKind.BLOCK_OPEN) {
            throw this.createParseException("Expected block open, {0}.", this.errorAtTokenStart());
        }
        return this.parseBlock();
    }

    protected TextBlocksSubReader parseBlock() throws CommonException {
        char ch = this.consumeChar();
        int ix = ArrayUtil.indexOf(this.blockOpens, ch);
        char expectedClose = this.blockCloses[ix];
        return new TextBlocksSubReader(this.charSource, this.blockOpens, this.blockCloses, expectedClose);
    }

    protected CommonException createParseException(String pattern, Object ... arguments) {
        return new CommonException(MessageFormat.format(pattern, arguments));
    }

    public String errorAtTokenStart() throws CommonException {
        return this.found(this.peekTokenStart());
    }

    protected String found(int ahead) {
        if (ahead == -1) {
            return "found EOS";
        }
        char ch = (char)ahead;
        return "found `" + ch + "`";
    }

    public void expectText(String expectedText) throws CommonException {
        if (this.tokenAhead() != TokenKind.TEXT) {
            throw this.createParseException("Expected text `{0}`, {1}.", expectedText, this.errorAtTokenStart());
        }
        String text = this.parseTextValue();
        if (!CoreUtil.areEqual(text, expectedText)) {
            throw this.createParseException("Expected text `{0}`, found text `{1}`.", expectedText, text);
        }
    }

    public <RET, EXC extends Exception> RET consumeBlock(BlockVisitorX<RET, EXC> visitor) throws CommonException, EXC {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TextBlocksSubReader subReader = this.enterBlock();){
            return visitor.consumeChildren(subReader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void skipNextElement() throws CommonException {
        if (this.aheadIsEnd()) {
            throw this.createParseException("Expected `{0}`, {1}.", "element", this.errorAtTokenStart());
        }
        if (this.aheadIsText()) {
            this.consumeText();
        } else {
            this.consumeBlock(subReader -> {
                subReader.skipToEnd();
                return null;
            });
        }
    }

    public void skipToEnd() throws CommonException {
        while (!this.aheadIsEnd()) {
            this.skipNextElement();
        }
    }

    public static interface BlockVisitorX<RET, EXC extends Exception> {
        public RET consumeChildren(TextBlocksSubReader var1) throws EXC;
    }

    public static class TextBlocksSubReader
    extends TextBlocksReader
    implements AutoCloseable {
        protected final char expectedClose;

        public TextBlocksSubReader(IBasicCharSource<? extends Exception> charSource, char[] blockOpens, char[] blockCloses, char expectedClose) {
            super(charSource, blockOpens, blockCloses);
            this.expectedClose = expectedClose;
        }

        @Override
        public void close() throws CommonException {
            int ahead = this.peekTokenStart();
            if (ahead != this.expectedClose) {
                throw this.createParseException("Expected BLOCK_CLOSE `{0}`, {1}.", Character.valueOf(this.expectedClose), this.errorAtTokenStart());
            }
            char ch = this.charSource.consume();
            Assert.AssertNamespace.assertTrue(ch == ahead);
        }
    }

    public static enum TokenKind {
        TEXT,
        BLOCK_OPEN,
        EOS;

    }
}

