/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.parser;

import java.util.Collections;
import melnorme.lang.utils.parse.LexingUtils;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;

public class SourceLinesInfo {
    protected final String source;
    protected final ArrayList2<Integer> lines;

    public SourceLinesInfo(String source) {
        this.source = source;
        this.lines = this.calculateLines(new StringCharSource(source));
    }

    protected ArrayList2<Integer> calculateLines(StringCharSource parser) {
        ArrayList2<Integer> lines = new ArrayList2<Integer>();
        int lineStartOffset = 0;
        do {
            this.consumeNewLine(parser);
            lines.add(lineStartOffset);
            lineStartOffset = parser.getReadPosition();
        } while (parser.hasCharAhead());
        return lines;
    }

    protected void consumeNewLine(StringCharSource parser) {
        while (true) {
            String newlineSequence;
            if ((newlineSequence = LexingUtils.determineNewlineSequenceAt(parser, 0)) != null) {
                parser.consumeAhead(newlineSequence);
                return;
            }
            parser.consume();
        }
    }

    public String getSource() {
        return this.source;
    }

    public void validateOffset(int offset) throws CommonException {
        if (offset > this.source.length()) {
            throw CommonException.fromMsgFormat("Invalid offset {0}, it is out of bounds.", offset);
        }
    }

    public int getNumberOfLines() {
        return this.lines.size();
    }

    public int getOffsetForLine(int lineIndex) {
        Assert.AssertNamespace.assertTrue(lineIndex >= 0 && lineIndex < this.lines.size());
        return (Integer)this.lines.get(lineIndex);
    }

    public int getLineForOffset(int offset) throws CommonException {
        this.validateOffset(offset);
        int binarySearchResult = Collections.binarySearch(this.lines, offset);
        return binarySearchResult >= 0 ? binarySearchResult : -(binarySearchResult + 1) - 1;
    }

    public int getLineStartForOffset(int offset) throws CommonException {
        return this.getOffsetForLine(this.getLineForOffset(offset));
    }

    public int getColumnForOffset(int offset) throws CommonException {
        return offset - this.getLineStartForOffset(offset);
    }

    public int getValidatedOffset_1(int line_1, int column_1) throws CommonException {
        if (line_1 < 1) {
            throw new CommonException("Invalid line number: " + line_1);
        }
        if (column_1 < 1) {
            throw new CommonException("Invalid column number: " + line_1);
        }
        int lineIndex = line_1 - 1;
        int columnIndex = column_1 - 1;
        if (lineIndex >= this.lines.size()) {
            throw CommonException.fromMsgFormat("Invalid line: {0} is over the max bound: {1}.", line_1, this.lines.size());
        }
        return this.getValidateOffset_do(lineIndex, columnIndex);
    }

    public int getValidatedOffset_0(int line_0, int column_0) throws CommonException {
        if (line_0 < 0) {
            throw new CommonException("Invalid line number: " + line_0);
        }
        if (column_0 < 0) {
            throw new CommonException("Invalid column number: " + line_0);
        }
        if (line_0 >= this.lines.size()) {
            throw CommonException.fromMsgFormat("Invalid line: {0} is over the max bound: {1}.", line_0, this.lines.size());
        }
        return this.getValidateOffset_do(line_0, column_0);
    }

    protected int getValidateOffset_do(int lineIndex, int columnIndex) throws CommonException {
        int offset = this.getOffsetForLine(lineIndex) + columnIndex;
        if (lineIndex + 1 < this.lines.size() && offset >= this.getOffsetForLine(lineIndex + 1)) {
            throw new CommonException("Invalid column, out of bounds.");
        }
        if (offset > this.source.length()) {
            throw new CommonException("Invalid line+column, out of bounds.");
        }
        return offset;
    }

    public int getIdentifierAt(int validatedOffset) {
        StringCharSource parser = new StringCharSource(this.source);
        parser.consume(validatedOffset);
        return LexingUtils.matchJavaIdentifier(parser);
    }
}

