/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.common.ops;

import melnorme.lang.tooling.common.ops.Operation;
import melnorme.utilbox.concurrency.ICancelMonitor;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;

public interface IOperationMonitor
extends ICancelMonitor {
    public IOperationSubMonitor enterSubTask(String var1);

    default public void runSubTask(String subTaskName, Operation subOp) throws CommonException, OperationCancellation {
        Throwable throwable = null;
        Object var4_5 = null;
        try (IOperationSubMonitor subMonitor = this.enterSubTask(subTaskName);){
            subOp.execute(subMonitor);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static abstract class BasicOperationMonitor
    implements IOperationMonitor {
        protected final ICancelMonitor cm;
        protected final String operationName;

        public BasicOperationMonitor(ICancelMonitor cm, String operationName, boolean initialize) {
            this.cm = Assert.AssertNamespace.assertNotNull(cm);
            this.operationName = operationName;
            if (initialize) {
                this.setTaskName();
            }
        }

        @Override
        public final boolean isCanceled() {
            return this.cm.isCanceled();
        }

        public void setTaskName() {
            if (this.operationName != null) {
                this.setTaskName(this.operationName);
            }
        }

        public abstract void setTaskName(String var1);

        @Override
        public IOperationSubMonitor enterSubTask(String subTaskName) {
            return new OperationSubMonitor(this, subTaskName);
        }
    }

    public static interface IOperationSubMonitor
    extends IOperationMonitor,
    AutoCloseable {
        @Override
        public void close();
    }

    public static class NullOperationMonitor
    extends BasicOperationMonitor {
        public NullOperationMonitor() {
            this(new ICancelMonitor.NullCancelMonitor());
        }

        public NullOperationMonitor(ICancelMonitor cm) {
            super(cm, null, true);
        }

        @Override
        public void setTaskName(String taskName) {
        }
    }

    public static class OperationSubMonitor
    extends BasicOperationMonitor
    implements IOperationSubMonitor {
        protected final BasicOperationMonitor parentMonitor;

        public OperationSubMonitor(BasicOperationMonitor parentMonitor, String operationName) {
            super(parentMonitor.cm, operationName, false);
            this.parentMonitor = Assert.AssertNamespace.assertNotNull(parentMonitor);
            this.setTaskName();
        }

        @Override
        public void close() {
            this.parentMonitor.setTaskName();
        }

        @Override
        public void setTaskName(String taskName) {
            this.parentMonitor.setTaskName(taskName);
        }
    }
}

