/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.common;

import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.HashcodeUtil;

public class SourceLineColumnRange {
    public final int line;
    public final int column;
    public final int endLine;
    public final int endColumn;

    public SourceLineColumnRange(int line_1, int column_1, int endLine, int endColumn) {
        this.line = line_1;
        this.column = column_1;
        this.endLine = endLine;
        this.endColumn = endColumn;
    }

    public SourceLineColumnRange(int line_1, int column_1) {
        this(line_1, column_1, -1, -1);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SourceLineColumnRange other = (SourceLineColumnRange)obj;
        return this.line == other.line && this.column == other.column && this.endLine == other.endLine && this.endColumn == other.endColumn;
    }

    public int hashCode() {
        return HashcodeUtil.combineHashCodes(this.column, this.line);
    }

    public String toString() {
        String startStr = String.valueOf(this.line) + (this.column == -1 ? "" : ":" + this.column);
        String endStr = this.endLine == -1 ? "" : " " + this.endLine + (this.endColumn == -1 ? "" : ":" + this.endColumn);
        return "[" + startStr + endStr + "]";
    }

    public int getLineIndex() {
        return SourceLineColumnRange.toIndex(this.line);
    }

    public int getColumnIndex() {
        return SourceLineColumnRange.toIndex(this.column);
    }

    protected static int toIndex(int oneBasedPosition) {
        return oneBasedPosition == -1 ? -1 : oneBasedPosition - 1;
    }

    protected static int toValidIndex(int position) throws CommonException {
        if (position <= 0) {
            throw new CommonException("Invalid position.");
        }
        return position - 1;
    }

    public int getValidLineIndex() throws CommonException {
        return SourceLineColumnRange.toValidIndex(this.line);
    }

    public int getValidColumnIndex() throws CommonException {
        return SourceLineColumnRange.toValidIndex(this.column);
    }

    public int getValidEndLineIndex() throws CommonException {
        return SourceLineColumnRange.toValidIndex(this.endLine);
    }

    public int getValidEndColumnIndex() throws CommonException {
        return SourceLineColumnRange.toValidIndex(this.endColumn);
    }
}

