/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.common;

import java.nio.file.Path;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.parser.SourceLinesInfo;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.NumberUtil;
import melnorme.utilbox.misc.PathUtil;
import melnorme.utilbox.misc.StringUtil;

public class SourceFileLocation {
    protected final String filePath;
    protected final String line;
    protected final String column;

    public SourceFileLocation(String filePath, String line, String column) {
        this.filePath = filePath;
        this.line = line;
        this.column = column;
    }

    public String getFileLocationString() {
        return this.filePath;
    }

    public String getLineString() {
        return this.line;
    }

    public String getColumnString() {
        return this.column;
    }

    public static SourceFileLocation parseSourceRange(String positionString, char separator) throws CommonException {
        String sourceRangeString = SourceFileLocation.getSourceRangeString(positionString, separator);
        if (sourceRangeString == null) {
            throw new CommonException("Source range not available in `" + positionString + "`");
        }
        String filePath = positionString.substring(0, positionString.length() - sourceRangeString.length() - 1);
        String lineStr_1based = StringUtil.segmentUntilMatch(sourceRangeString, ":");
        String columnStr_1based = StringUtil.segmentAfterMatch(sourceRangeString, ":");
        return new SourceFileLocation(filePath, lineStr_1based, columnStr_1based);
    }

    protected static String getSourceRangeString(String posString, char separator) {
        int ix = posString.length();
        int count = 0;
        while (--ix >= 0) {
            if (posString.charAt(ix) != separator || ++count != 2) continue;
            return posString.substring(ix + 1, posString.length());
        }
        return null;
    }

    public Location getFileLocation() throws CommonException {
        return Location.create(this.filePath);
    }

    public Path getFilePath() throws CommonException {
        return PathUtil.createPath(this.filePath);
    }

    public SourceRange parseSourceRangeFrom1BasedIndex(SourceLinesInfo sourceLinesInfo) throws CommonException {
        int line_1based = NumberUtil.parseInt(this.line);
        int column_1based = NumberUtil.parseInt(this.column);
        int validatedOffset = sourceLinesInfo.getValidatedOffset_1(line_1based, column_1based);
        int length = sourceLinesInfo.getIdentifierAt(validatedOffset);
        return new SourceRange(validatedOffset, length);
    }
}

