/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.commands;

import java.util.Map;
import melnorme.lang.tooling.commands.CommandInvocation;
import melnorme.lang.utils.DocumentSerializerHelper;
import melnorme.utilbox.collections.HashMap2;
import melnorme.utilbox.collections.MapAccess;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.CollectionUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CommandInvocationSerializer
extends DocumentSerializerHelper<CommandInvocation> {
    public static final String PROP_COMMAND_INVOCATION = "command_invocation";
    private static final String PROP_ARGUMENTS = "command_arguments";
    private static final String ELEM_ENV_VARS = "env_vars";
    private static final String PROP_APPEND_ENV = "append_env";
    private static final String ELEM_ENTRY = "entry";
    private static final String PROP_KEY = "key";

    @Override
    protected void writeDocument(Document doc, CommandInvocation command) {
        this.writeToParent(doc, command);
    }

    public void writeToParent(Node parentElement, CommandInvocation command) {
        if (command != null) {
            Element buildCommandElem = this.getDocumentParent(parentElement).createElement(PROP_COMMAND_INVOCATION);
            parentElement.appendChild(buildCommandElem);
            this.writeToElement(buildCommandElem, command);
        }
    }

    public void writeToElement(Element targetElem, CommandInvocation buildCommand) {
        CommandInvocationSerializer.setAttribute(targetElem, PROP_ARGUMENTS, buildCommand.commandLine);
        CommandInvocationSerializer.setAttribute(targetElem, PROP_APPEND_ENV, Boolean.toString(buildCommand.appendEnvironment));
        Element envVars = this.addChild(targetElem, ELEM_ENV_VARS);
        this.writeEnvVars(envVars, buildCommand.environmentVars);
    }

    public void writeEnvVars(Element envVarsElement, MapAccess<String, String> envVars) {
        for (Map.Entry entry : CollectionUtil.nullToEmpty(envVars)) {
            Element entryElement = this.addChild(envVarsElement, ELEM_ENTRY);
            entryElement.setAttribute(PROP_KEY, (String)entry.getKey());
            this.addTextChild(entryElement, (String)entry.getValue());
        }
    }

    @Override
    public CommandInvocation doReadFromString(String targetsXml) throws CommonException {
        Document doc = this.parseDocumentFromXml(targetsXml);
        int ix = 0;
        while (ix < doc.getChildNodes().getLength()) {
            Node node = doc.getChildNodes().item(ix);
            if (node.getNodeName().equals(PROP_COMMAND_INVOCATION)) {
                return this.readFromNode(node);
            }
            ++ix;
        }
        return null;
    }

    public CommandInvocation readFromNode(Node cmdElement) {
        String commandArguments = CommandInvocationSerializer.getAttribute(cmdElement, PROP_ARGUMENTS, "");
        boolean appendEnv = CommandInvocationSerializer.getBooleanAttribute(cmdElement, PROP_APPEND_ENV, true);
        HashMap2<String, String> envVars = new HashMap2<String, String>();
        int ix = 0;
        while (ix < cmdElement.getChildNodes().getLength()) {
            Node node = cmdElement.getChildNodes().item(ix);
            if (node.getNodeName().equals(ELEM_ENV_VARS)) {
                this.readEnvVars(envVars, node);
            }
            ++ix;
        }
        return new CommandInvocation(commandArguments, envVars, appendEnv);
    }

    public void readEnvVars(HashMap2<String, String> envVars, Node envVarsNode) {
        int ix = 0;
        while (ix < envVarsNode.getChildNodes().getLength()) {
            String key;
            Node child = envVarsNode.getChildNodes().item(ix);
            if (child.getNodeType() == 1 && child.getNodeName().equals(ELEM_ENTRY) && (key = CommandInvocationSerializer.getAttribute(child, PROP_KEY, null)) != null) {
                String entryValue = child.getTextContent();
                envVars.put(key, entryValue);
            }
            ++ix;
        }
    }
}

