/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.commands;

import java.util.Map;
import melnorme.lang.tooling.commands.IVariablesResolver;
import melnorme.lang.tooling.utils.ArgumentsParser;
import melnorme.lang.utils.ProcessUtils;
import melnorme.utilbox.collections.HashMap2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.collections.MapAccess;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.fields.validation.ValidatedValueSource;
import melnorme.utilbox.misc.HashcodeUtil;
import melnorme.utilbox.status.Severity;
import melnorme.utilbox.status.StatusException;

public class CommandInvocation {
    protected final String commandLine;
    protected final MapAccess<String, String> environmentVars;
    protected final boolean appendEnvironment;

    public CommandInvocation(String commandLine) {
        this(commandLine, null, true);
    }

    public CommandInvocation(String commandLine, MapAccess<String, String> envVars, boolean appendEnv) {
        this.commandLine = Assert.AssertNamespace.assertNotNull(commandLine);
        this.environmentVars = envVars != null ? envVars : new HashMap2();
        this.appendEnvironment = appendEnv;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CommandInvocation)) {
            return false;
        }
        CommandInvocation other = (CommandInvocation)obj;
        return CoreUtil.areEqual(this.commandLine, other.commandLine) && CoreUtil.areEqual(this.environmentVars, other.environmentVars) && CoreUtil.areEqual(this.appendEnvironment, other.appendEnvironment);
    }

    public int hashCode() {
        return HashcodeUtil.combinedHashCode(this.commandLine, this.environmentVars);
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public Indexable<String> parseCommandLineArguments() {
        return ArgumentsParser.parse(this.commandLine);
    }

    public MapAccess<String, String> getEnvironmentVars() {
        return this.environmentVars;
    }

    public boolean isAppendEnvironment() {
        return this.appendEnvironment;
    }

    public CommandInvocation getResolvedCommandInvocation(IVariablesResolver variablesResolver) throws StatusException, CommonException {
        String commandLine = this.evaluateCommandArguments(variablesResolver);
        HashMap2<String, String> resolvedEnvVars = new HashMap2<String, String>();
        for (Map.Entry entry : this.getEnvironmentVars()) {
            String newValue = variablesResolver.performStringSubstitution((String)entry.getValue());
            resolvedEnvVars.put((String)entry.getKey(), newValue);
        }
        return new CommandInvocation(commandLine, resolvedEnvVars, this.isAppendEnvironment());
    }

    public ProcessBuilder getProcessBuilder(IVariablesResolver variablesResolver) throws CommonException {
        return this.getResolvedCommandInvocation(variablesResolver).getProcessBuilder();
    }

    public ProcessBuilder getProcessBuilder() {
        Indexable<String> commandLine = this.parseCommandLineArguments();
        ProcessBuilder pb = ProcessUtils.createProcessBuilder(commandLine, null);
        Map<String, String> environment = pb.environment();
        if (!this.isAppendEnvironment()) {
            environment.clear();
        }
        for (Map.Entry entry : this.getEnvironmentVars()) {
            environment.put((String)entry.getKey(), (String)entry.getValue());
        }
        return pb;
    }

    public void validate(IVariablesResolver variablesResolver) throws StatusException {
        this.evaluateCommandArguments(variablesResolver);
    }

    public String evaluateCommandArguments(IVariablesResolver variablesResolver) throws StatusException {
        return this.getValidatedCommandArguments(variablesResolver).getValidatedValue();
    }

    protected ValidatedCommandArgumentsSource getValidatedCommandArguments(IVariablesResolver variablesResolver) {
        return new ValidatedCommandArgumentsSource(this.commandLine, variablesResolver);
    }

    public static class ValidatedCommandArgumentsSource
    implements ValidatedValueSource<String> {
        public static final String MSG_NO_COMMAND_SPECIFIED = "No command specified.";
        protected final IVariablesResolver variablesResolver;
        protected final String commandArguments;

        public ValidatedCommandArgumentsSource(String commandArguments, IVariablesResolver variablesResolver) {
            this.commandArguments = commandArguments;
            this.variablesResolver = variablesResolver;
        }

        @Override
        public String getValidatedValue() throws StatusException {
            try {
                return this.doGetValidatedValue(this.variablesResolver);
            }
            catch (CommonException e) {
                throw e.toStatusException(Severity.WARNING);
            }
        }

        public String doGetValidatedValue(IVariablesResolver variablesResolver) throws CommonException {
            String evaluatedCommandLine;
            if (this.commandArguments == null) {
                this.handleNoCommandLine();
            }
            if ((evaluatedCommandLine = variablesResolver.performStringSubstitution(this.commandArguments)).trim().isEmpty()) {
                this.handleNoCommandLine();
            }
            return evaluatedCommandLine;
        }

        protected void handleNoCommandLine() throws CommonException {
            throw new CommonException(MSG_NO_COMMAND_SPECIFIED);
        }
    }
}

