/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.bundle;

import java.text.MessageFormat;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;
import melnorme.utilbox.misc.StringUtil;

public class DependencyRef {
    protected final String bundleName;
    protected final String version;
    protected final boolean optional;

    public DependencyRef(String bundleName, String version) {
        this(bundleName, version, false);
    }

    public DependencyRef(String bundleName, String version, boolean optional) {
        this.bundleName = Assert.AssertNamespace.assertNotNull(bundleName);
        this.version = version;
        this.optional = optional;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DependencyRef)) {
            return false;
        }
        DependencyRef other = (DependencyRef)obj;
        return CoreUtil.areEqual(this.bundleName, other.bundleName) && CoreUtil.areEqual(this.version, other.version) && CoreUtil.areEqual(this.optional, other.optional);
    }

    public int hashCode() {
        return HashcodeUtil.combinedHashCode(this.bundleName, this.version, this.optional);
    }

    public String toString() {
        return MessageFormat.format("{0}@{1}{2}", this.bundleName, StringUtil.nullAsEmpty(this.version), this.optional ? " OPT" : "");
    }

    public String getBundleName() {
        return this.bundleName;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean getIsOptional() {
        return this.optional;
    }
}

