/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.bundle;

import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.StringUtil;

public class BuildTargetNameParser {
    protected final String nameSeparator;

    public BuildTargetNameParser() {
        this(":");
    }

    public BuildTargetNameParser(String nameSeparator) {
        this.nameSeparator = Assert.AssertNamespace.assertNotNull(nameSeparator);
    }

    public String getBuildConfig(String buildTargetName) {
        return this.getBuildConfigName(buildTargetName);
    }

    public String getBuildType(String buildTargetName) {
        return this.getBuildTypeName(buildTargetName);
    }

    public final String getNameSeparator() {
        return this.nameSeparator;
    }

    public String getFullName(String buildConfig, String buildType) {
        return String.valueOf(buildConfig) + StringUtil.prefixStr(this.getNameSeparator(), StringUtil.emptyAsNull(buildType));
    }

    public String getBuildConfigName(String targetName) {
        return StringUtil.substringUntilMatch(targetName, this.getNameSeparator());
    }

    public String getBuildTypeName(String targetName) {
        return StringUtil.segmentAfterMatch(targetName, this.getNameSeparator());
    }
}

