/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.bundle;

import java.nio.file.Path;
import melnorme.lang.tooling.BundlePath;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;

public abstract class AbstractBundlePath {
    public final Location location;

    public static BundlePath create(String pathStr) {
        try {
            Path path = MiscUtil.createPath(pathStr);
            return BundlePath.create(path);
        }
        catch (CommonException e) {
            return null;
        }
    }

    public static BundlePath create(Path path) {
        if (AbstractBundlePath.isValidBundlePath(path)) {
            return new BundlePath(Location.fromAbsolutePath(path));
        }
        return null;
    }

    public static BundlePath create(Location location) {
        if (AbstractBundlePath.isValidBundlePath(location.path)) {
            return new BundlePath(location);
        }
        return null;
    }

    public static boolean isValidBundlePath(Path path) {
        Assert.AssertNamespace.assertNotNull(path);
        return path.isAbsolute() && path.getNameCount() > 0;
    }

    public AbstractBundlePath(Location location) {
        Assert.AssertNamespace.assertTrue(BundlePath.isValidBundlePath(location.path));
        this.location = location;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BundlePath)) {
            return false;
        }
        BundlePath other = (BundlePath)obj;
        return CoreUtil.areEqual(this.location, other.location);
    }

    public int hashCode() {
        return this.location.hashCode();
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean hasBundleManifest() {
        return this.getManifestLocation(false) != null;
    }

    public abstract Location getManifestLocation(boolean var1);

    public Location resolve(Path other) {
        return this.location.resolve(other);
    }

    public String toString() {
        return this.location.toString();
    }

    public static Location getManifest(Location bundleLoc, Indexable<Path> manifestSubPaths, Path defaultManifestPath) {
        for (Path manifestSubPath : manifestSubPaths) {
            Location manifestLoc = bundleLoc.resolve(manifestSubPath);
            if (!manifestLoc.toFile().exists()) continue;
            return manifestLoc;
        }
        return defaultManifestPath == null ? null : bundleLoc.resolve(defaultManifestPath);
    }

    public static BundlePath findBundleForPath(Location path) {
        if (path == null) {
            return null;
        }
        BundlePath bundlePath = AbstractBundlePath.create(path);
        if (bundlePath != null && bundlePath.hasBundleManifest()) {
            return bundlePath;
        }
        return AbstractBundlePath.findBundleForPath(path.getParent());
    }
}

