/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling.ast;

import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.NumberUtil;

public final class SourceRange
implements Comparable<SourceRange> {
    public final int offset;
    public final int length;

    public SourceRange(int offset, int length) {
        Assert.AssertNamespace.assertTrue(offset >= 0);
        Assert.AssertNamespace.assertTrue(length >= 0);
        this.offset = offset;
        this.length = length;
    }

    public static SourceRange srStartToEnd(int startPos, int endPos) {
        Assert.AssertNamespace.assertTrue(startPos >= 0 && endPos >= startPos);
        return new SourceRange(startPos, endPos - startPos);
    }

    public final int getOffset() {
        return this.offset;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getStartPos() {
        return this.getOffset();
    }

    public final int getEndPos() {
        return this.getOffset() + this.getLength();
    }

    public final String toString() {
        return "[" + this.offset + "+" + this.length + "]";
    }

    public final boolean equals(Object obj) {
        if (!(obj instanceof SourceRange)) {
            return false;
        }
        SourceRange other = (SourceRange)CoreUtil.downCast(obj);
        return this.offset == other.offset && this.length == other.length;
    }

    @Override
    public int compareTo(SourceRange other) {
        if (this.offset == other.offset) {
            return this.length - other.length;
        }
        return this.offset - other.offset;
    }

    public boolean contains(SourceRange other) {
        return this.contains(other.getStartPos()) && this.contains(other.getEndPos());
    }

    public boolean contains(int otherOffset) {
        return NumberUtil.isInRange(this.getStartPos(), otherOffset, this.getEndPos());
    }

    public boolean inclusiveContains(int otherOffset) {
        return this.contains(otherOffset);
    }

    public boolean inclusiveContains(SourceRange other) {
        return this.contains(other);
    }

    public String getRangeSubString(String source) {
        return source.substring(this.getStartPos(), this.getEndPos());
    }
}

