/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling;

import melnorme.lang.tooling.AbstractKindVisitor;
import melnorme.utilbox.core.Assert;

public enum CompletionProposalKind {
    UNKNOWN,
    KEYWORD,
    ERROR,
    PACKAGE,
    VARIABLE,
    FUNCTION,
    INTERFACE,
    STRUCT,
    TYPE_DECL,
    NATIVE;


    public <RET> RET switchOnKind(ProposalKindVisitor<RET> visitor) {
        switch (this) {
            case UNKNOWN: {
                return visitor.visitUnknown();
            }
            case KEYWORD: {
                return visitor.visitKeyword();
            }
            case ERROR: {
                return visitor.visitError();
            }
            case PACKAGE: {
                return visitor.visitPackage();
            }
            case VARIABLE: {
                return visitor.visitVariable();
            }
            case FUNCTION: {
                return visitor.visitFunction();
            }
            case STRUCT: {
                return visitor.visitStruct();
            }
            case INTERFACE: {
                return visitor.visitInterface();
            }
            case TYPE_DECL: {
                return visitor.visitTypeDecl();
            }
            case NATIVE: {
                return visitor.visitNative();
            }
        }
        throw Assert.AssertNamespace.assertUnreachable();
    }

    public static interface ProposalKindVisitor<RET>
    extends AbstractKindVisitor<RET> {
        public RET visitError();

        public RET visitPackage();

        public RET visitTypeDecl();
    }
}

