/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tooling;

import java.util.EnumSet;
import melnorme.lang.tooling.EAttributeFlag;
import melnorme.lang.tooling.EProtection;
import melnorme.lang.tooling.ElementAttributes;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.HashcodeUtil;
import melnorme.utilbox.misc.StringUtil;

abstract class AbstractElementAttributes {
    protected final EProtection protection;
    protected final EnumSet<EAttributeFlag> flagsSet;

    public AbstractElementAttributes(EProtection protection, EnumSet<EAttributeFlag> flagsSet) {
        this.protection = protection;
        this.flagsSet = Assert.AssertNamespace.assertNotNull(flagsSet);
    }

    public AbstractElementAttributes(EProtection protection, EAttributeFlag ... flagsArray) {
        this(protection, AbstractElementAttributes.newFlagsSet(flagsArray));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ElementAttributes)) {
            return false;
        }
        ElementAttributes other = (ElementAttributes)obj;
        return CoreUtil.areEqual(this.protection, other.protection) && CoreUtil.areEqual(this.flagsSet, other.flagsSet);
    }

    public int hashCode() {
        return HashcodeUtil.combinedHashCode(this.protection, this.flagsSet);
    }

    public EProtection getProtection() {
        return this.protection;
    }

    public Iterable<EAttributeFlag> getFlagsSet() {
        return this.flagsSet;
    }

    public String toString() {
        String protString = this.getProtection() == null ? "" : this.getProtection().toString();
        return "ATTRIBS[" + protString + ";" + StringUtil.collToString(this.flagsSet, ",") + "]";
    }

    public boolean hasFlag(EAttributeFlag flag) {
        return this.flagsSet.contains((Object)flag);
    }

    protected void setFlag(EAttributeFlag flag, boolean enabled) {
        if (enabled) {
            this.flagsSet.add(flag);
        } else {
            this.flagsSet.remove((Object)flag);
        }
    }

    public static EnumSet<EAttributeFlag> newFlagsSet(EAttributeFlag ... flagsArray) {
        Assert.AssertNamespace.assertNotNull(flagsArray);
        EnumSet<EAttributeFlag> flags = EnumSet.noneOf(EAttributeFlag.class);
        EAttributeFlag[] eAttributeFlagArray = flagsArray;
        int n = flagsArray.length;
        int n2 = 0;
        while (n2 < n) {
            EAttributeFlag flag = eAttributeFlagArray[n2];
            flags.add(flag);
            ++n2;
        }
        return flags;
    }
}

