/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.tests;

import melnorme.lang.tests.CommonLexerRuleTest;
import melnorme.lang.tooling.parser.lexer.IPredicateLexingRule;
import melnorme.lang.tooling.parser.lexer.NumberLexingRule;
import melnorme.lang.utils.parse.ICharacterReader;
import org.junit.Test;

public class NumberRuleTest
extends CommonLexerRuleTest {
    @Override
    protected IPredicateLexingRule createLexingRule() {
        return new NumberLexingRule(){

            @Override
            protected boolean consumeIntSuffix(ICharacterReader reader) {
                return false;
            }

            @Override
            protected boolean consumeFloatSuffix(ICharacterReader reader) {
                return false;
            }
        };
    }

    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        this.testInteger();
        this.testFloats();
    }

    protected void testInteger() {
        this.testRule("", 0);
        this.testRule("xxx", 0);
        this.testRule("xxx123", 0);
        this.testRule("0", 1);
        this.testRule("2", 1);
        this.testRule("123", 3);
        this.testRule("12_3_", 5);
        this.testRule("10_20_30", 8);
        this.testRule("_", 0);
        this.testRule("123:", 3);
        this.testRule("123/", 3);
        this.testRule("123xxx", 3);
        this.testRule("123.4xxx", 5);
        this.testRule("0b_010", 6);
        this.testRule("0o7_17", 6);
        this.testRule("0xF1F_", 6);
        this.testRule("0b012", 4);
        this.testRule("0o718", 4);
        this.testRule("0xF1G", 4);
    }

    protected void testFloats() {
        this.testRule("123.0", 5);
        this.testRule("123.19", 6);
        this.testRule("123.", 4);
        this.testRule("123. a", 4);
        this.testRule("123.a", 3);
        this.testRule("123..", 3);
        this.testRule("123,", 3);
        this.testFractionalPartIfLiteralHasRadixPrefix();
        this.testFloat_exponentPart();
    }

    protected void testFractionalPartIfLiteralHasRadixPrefix() {
        this.testRule("0o0.11", 3);
        this.testRule("0b0.11", 3);
        this.testRule("0x0.11", 3);
    }

    protected void testFloat_exponentPart() {
        this.testRule("123.15E", 7);
        this.testRule("123.15e109", 10);
        this.testRule("123.15E+19", 10);
        this.testRule("123.15E-19", 10);
        this.testRule("123.E1", 3);
        this.testRule("123._E1", 3);
        this.testRule("123.1_E1", 8);
    }
}

