/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.oracle;

import com.googlecode.goclipse.tooling.CommonGoToolingTest;
import com.googlecode.goclipse.tooling.oracle.GuruPackageDescribeParser;
import melnorme.lang.tooling.EAttributeFlag;
import melnorme.lang.tooling.EProtection;
import melnorme.lang.tooling.ElementAttributes;
import melnorme.lang.tooling.ast.ParserErrorTypes;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.common.ParserError;
import melnorme.lang.tooling.structure.AbstractStructureParser;
import melnorme.lang.tooling.structure.AbstractStructureParser_Test;
import melnorme.lang.tooling.structure.SourceFileStructure;
import melnorme.lang.tooling.structure.StructureElement;
import melnorme.lang.tooling.structure.StructureElementKind;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.ArrayUtil;
import melnorme.utilbox.misc.Location;
import org.junit.Test;

public class GuruPackageDescribeParser_Test
extends AbstractStructureParser_Test {
    protected Location location;
    protected static final String USER__Type = "func(username string) *util.Userinfo";

    @Override
    public String getClassResource(String resourceName) {
        return CommonGoToolingTest.fixTestsPaths(super.getClassResource(resourceName));
    }

    public static ElementAttributes attrib(EProtection protection, EAttributeFlag ... flags) {
        return new ElementAttributes(protection, flags);
    }

    public static ElementAttributes att(EAttributeFlag ... flags) {
        return new ElementAttributes(EProtection.PUBLIC, flags);
    }

    public static ElementAttributes attPriv(EAttributeFlag ... flags) {
        return new ElementAttributes(EProtection.PRIVATE, flags);
    }

    protected static ElementAttributes eat(EAttributeFlag ... flags) {
        return GuruPackageDescribeParser_Test.att(ArrayUtil.concat(flags, EAttributeFlag.TEMPLATED));
    }

    protected ArrayList2<StructureElement> elems(StructureElement ... expectedElements) {
        return new ArrayList2<StructureElement>(expectedElements);
    }

    public StructureElement elem(String name, SourceRange nameSR, StructureElementKind elementKind, ElementAttributes elementAttributes, String type, Indexable<StructureElement> children) {
        return new StructureElement(name, nameSR, nameSR, elementKind, elementAttributes, type, children);
    }

    protected void testParseStructure(String describeOutput, String goSource, StructureElement ... expectedElements) throws CommonException {
        this.location = null;
        this.source = goSource;
        super.testParseStructure(describeOutput, GuruPackageDescribeParser_Test.list(new ParserError[0]), expectedElements);
    }

    protected void testParseStructure(String describeOutput, String goSource, Location location, StructureElement ... expectedElements) throws CommonException {
        this.location = location;
        this.source = goSource;
        GuruPackageDescribeParser parser = this.createStructureParser();
        SourceFileStructure structure = ((AbstractStructureParser)parser).parse(describeOutput);
        ArrayList2<StructureElement> expectedStructure = new ArrayList2<StructureElement>(expectedElements);
        SourceFileStructure expected = new SourceFileStructure(location, expectedStructure, null);
        GuruPackageDescribeParser_Test.assertAreEqual(structure.getChildren(), expected.getChildren());
        GuruPackageDescribeParser_Test.assertEquals(structure, expected);
    }

    @Override
    protected GuruPackageDescribeParser createStructureParser() {
        return new GuruPackageDescribeParser(this.location, this.source);
    }

    public int ixof(String marker) {
        int indexOf = this.source.indexOf(marker);
        Assert.AssertNamespace.assertTrue(indexOf >= 0);
        return indexOf;
    }

    public SourceRange sr(String marker) {
        return this.sr(this.ixof(marker), marker.length());
    }

    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        this.testParseStructure(this.getClassResource("oracle_describe.0_Empty.json"), "", new StructureElement[0]);
        this.source = this.getClassResource("oracle_describe.1_Basic.go");
        this.testParseStructure(this.getClassResource("oracle_describe.1_Basic.json"), this.source, this.elem("Hello", this.sr("Hello"), StructureElementKind.FUNCTION, GuruPackageDescribeParser_Test.att(new EAttributeFlag[0]), "func()", null), this.elem("other", this.sr("other"), StructureElementKind.FUNCTION, GuruPackageDescribeParser_Test.attPriv(new EAttributeFlag[0]), "func()", null), this.elem("i2", this.sr("i2"), StructureElementKind.VARIABLE, GuruPackageDescribeParser_Test.attPriv(new EAttributeFlag[0]), "int", null), this.elem("xxx", this.sr("xxx"), StructureElementKind.VARIABLE, GuruPackageDescribeParser_Test.attPriv(new EAttributeFlag[0]), "int", null));
        try {
            this.testParseStructure(this.getClassResource("oracle_describe.2_Error1.json"), "", new StructureElement[0]);
            Assert.AssertNamespace.assertFail();
        }
        catch (CommonException commonException) {
            // empty catch block
        }
        try {
            this.testParseStructure(this.getClassResource("oracle_describe.2_Error2a.json"), "", new StructureElement[0]);
            Assert.AssertNamespace.assertFail();
        }
        catch (CommonException e) {
            Assert.AssertNamespace.assertTrue(e.toString().contains("Invalid line number: 0"));
        }
        try {
            this.testParseStructure(this.getClassResource("oracle_describe.2_Error2b.json"), "", new StructureElement[0]);
            Assert.AssertNamespace.assertFail();
        }
        catch (CommonException e) {
            Assert.AssertNamespace.assertTrue(e.toString().contains("Invalid line: 10 is over the max bound: 1."));
        }
        this.source = this.getClassResource("oracle_describe.2_Test.go");
        this.testParseStructure(this.getClassResource("oracle_describe.2_Test.json"), this.source, Location.create(CommonGoToolingTest.fixTestsPaths("D:/devel/tools.Go/go-workspace/src/util/libfoo/libfoo.go")), this.elem("encodeFragment", this.sr("encodeFragment"), StructureElementKind.CONST, GuruPackageDescribeParser_Test.attPriv(new EAttributeFlag[0]), "util.encoding", null), this.elem("Hello2", this.sr("Hello2"), StructureElementKind.FUNCTION, GuruPackageDescribeParser_Test.att(new EAttributeFlag[0]), "func()", null), this.elem("xxx", this.sr("xxx"), StructureElementKind.VARIABLE, GuruPackageDescribeParser_Test.attPriv(new EAttributeFlag[0]), "int", null), this.elem("User", this.sr("User"), StructureElementKind.FUNCTION, GuruPackageDescribeParser_Test.att(new EAttributeFlag[0]), USER__Type, null), this.elem("geometry", this.sr("geometry"), StructureElementKind.INTERFACE, GuruPackageDescribeParser_Test.attPriv(new EAttributeFlag[0]), null, this.elems(this.elem("area", this.sr("area"), StructureElementKind.METHOD, GuruPackageDescribeParser_Test.att(new EAttributeFlag[0]), "func() float64", null), this.elem("perim", this.sr("perim"), StructureElementKind.METHOD, GuruPackageDescribeParser_Test.att(new EAttributeFlag[0]), "func() float64", null))), this.elem("URL", this.sr("URL"), StructureElementKind.STRUCT, GuruPackageDescribeParser_Test.att(new EAttributeFlag[0]), null, this.elems(this.elem("IsAbs", this.sr("IsAbs"), StructureElementKind.METHOD, GuruPackageDescribeParser_Test.att(new EAttributeFlag[0]), "func() bool", null), this.elem("Parse", this.sr("Parse"), StructureElementKind.METHOD, GuruPackageDescribeParser_Test.att(new EAttributeFlag[0]), "func(ref string) (*URL, error)", null))));
        this.source = this.getClassResource("oracle_describe.A_std_url.go");
        new GuruPackageDescribeParser(null, this.source).parse(this.getClassResource("oracle_describe.A_std_url.json"));
        this.source = "aaaaa\n0123456789\nxxx\nabcdefghijkl\n";
        this.testParseStructure(this.getClassResource("oracle_describe.3_methods.json"), this.source, Location.create(CommonGoToolingTest.fixTestsPaths("D:/devel/tools.Go/go-workspace/src/util/other/hello_other.go")), new StructureElement("MainController", null, this.sr(7, 0), StructureElementKind.STRUCT, GuruPackageDescribeParser_Test.att(new EAttributeFlag[0]), null, this.elems(this.elem("RegisterJson", this.sr(7, 0), StructureElementKind.METHOD, GuruPackageDescribeParser_Test.att(new EAttributeFlag[0]), "func()", null))));
    }

    @Test
    public void testErrorParse() throws Exception {
        this.testErrorParse$();
    }

    public void testErrorParse$() throws Exception {
        this.source = "aaaaa\n0123456789\nxxx\nabcdefghijkl\n";
        GuruPackageDescribeParser parser = this.createStructureParser();
        String errorMsg = "oracle: C:\\Users\\Bruno\\src\\describe.go:1:2: expected operand, found 'for'";
        SourceFileStructure structure = parser.parseErrorMessage(errorMsg);
        GuruPackageDescribeParser_Test.assertEquals(structure, new SourceFileStructure(this.location, GuruPackageDescribeParser_Test.list(new StructureElement[0]), GuruPackageDescribeParser_Test.list(new ParserError(ParserErrorTypes.GENERIC_ERROR, this.srAt(7, 8), "expected operand, found 'for'", null))));
    }
}

