/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.oracle;

import com.googlecode.goclipse.tooling.oracle.JSONParseHelpers;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import melnorme.lang.tooling.EAttributeFlag;
import melnorme.lang.tooling.EProtection;
import melnorme.lang.tooling.ElementAttributes;
import melnorme.lang.tooling.ast.ParserErrorTypes;
import melnorme.lang.tooling.ast.SourceRange;
import melnorme.lang.tooling.common.LineColumnPosition;
import melnorme.lang.tooling.common.ParserError;
import melnorme.lang.tooling.common.SourceFileLocation;
import melnorme.lang.tooling.structure.AbstractStructureParser;
import melnorme.lang.tooling.structure.SourceFileStructure;
import melnorme.lang.tooling.structure.StructureElement;
import melnorme.lang.tooling.structure.StructureElementKind;
import melnorme.lang.tooling.toolchain.ops.ToolOutputParseHelper;
import melnorme.lang.utils.parse.LexingUtils;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.process.ExternalProcessHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GuruPackageDescribeParser
extends AbstractStructureParser {
    protected static final Pattern GO_MESSAGE_LINE_Regex = Pattern.compile("^([^:\\n]*):(\\d*):((\\d*):)?\\s(.*)$");

    public GuruPackageDescribeParser(Location location, String goSource) {
        super(location, goSource);
    }

    public SourceFileStructure parse(ExternalProcessHelper.ExternalProcessResult result) throws CommonException {
        if (result.exitValue != 0) {
            String errorMsg = result.getStdErrBytes().toString(StringUtil.UTF8);
            return this.parseErrorMessage(errorMsg);
        }
        return this.parse(result.getStdOutBytes().toString(StringUtil.UTF8));
    }

    @Override
    public SourceFileStructure parse(String describeOutput) throws CommonException {
        ArrayList2<StructureElement> elements;
        try {
            elements = this.doParseJsonResult(describeOutput);
        }
        catch (JSONException e) {
            throw new CommonException("Error parsing JSON output: ", e);
        }
        return new SourceFileStructure(this.location, elements, null);
    }

    protected ArrayList2<StructureElement> doParseJsonResult(String output) throws JSONException, CommonException {
        JSONObject describe = new JSONObject(output);
        JSONObject packageObj = describe.getJSONObject("package");
        JSONArray members = this.getOptionalJSONArray(packageObj, "members");
        return this.parseElements(members, false);
    }

    protected JSONArray getOptionalJSONArray(JSONObject packageObj, String key) throws JSONException {
        if (!packageObj.has(key)) {
            return null;
        }
        return packageObj.getJSONArray(key);
    }

    protected ArrayList2<StructureElement> parseElements(JSONArray members, boolean parsingMethods) throws JSONException, CommonException {
        ArrayList2<StructureElement> elements = new ArrayList2<StructureElement>();
        if (members != null) {
            int i = 0;
            while (i < members.length()) {
                Object object = members.get(i);
                if (object instanceof JSONObject) {
                    JSONObject jsonObject = (JSONObject)object;
                    StructureElement element = this.parseStructureElement(jsonObject, parsingMethods);
                    if (element != null) {
                        elements.add(element);
                    }
                } else {
                    throw new CommonException("'members' element is not a JSONObject: " + object);
                }
                ++i;
            }
        }
        Collections.sort(elements, new Comparator<StructureElement>(){

            @Override
            public int compare(StructureElement o1, StructureElement o2) {
                SourceRange sr1 = o1.getSourceRange();
                SourceRange sr2 = o2.getSourceRange();
                int cmp = sr1.getOffset() - sr2.getOffset();
                if (cmp == 0) {
                    int offset1 = o1.getNameSourceRange2() == null ? 0 : o1.getNameSourceRange2().getOffset();
                    int offset2 = o2.getNameSourceRange2() == null ? 0 : o2.getNameSourceRange2().getOffset();
                    return offset1 - offset2;
                }
                return cmp;
            }
        });
        return elements;
    }

    protected StructureElement parseStructureElement(JSONObject object, boolean parsingMethods) throws JSONException, CommonException {
        int idLength;
        String fullName;
        StructureElementKind elementKind;
        SourceRange sourceRange;
        SourceRange nameSourceRange;
        String name = JSONParseHelpers.readString(object, "name");
        String posString = JSONParseHelpers.readString(object, "pos");
        SourceFileLocation elementSourceFileLoc = SourceFileLocation.parseSourceRange(posString, ':');
        if (!this.isSourceElementLocation(elementSourceFileLoc.getFileLocation())) {
            nameSourceRange = null;
            sourceRange = null;
        } else {
            sourceRange = nameSourceRange = elementSourceFileLoc.parseSourceRangeFrom1BasedIndex(this.sourceLinesInfo);
        }
        String type = JSONParseHelpers.readOptionalString(object, "type");
        String kindString = JSONParseHelpers.readOptionalString(object, "kind");
        if (parsingMethods) {
            elementKind = StructureElementKind.METHOD;
        } else {
            if (kindString == null) {
                throw new CommonException("No `kind` field for element: " + name);
            }
            elementKind = this.parseKind(kindString, type);
        }
        if (elementKind == StructureElementKind.STRUCT || elementKind == StructureElementKind.INTERFACE) {
            type = null;
        } else if (elementKind == StructureElementKind.METHOD && name.startsWith("method ") && (name = name.substring("method ".length())).startsWith("(") && (fullName = StringUtil.segmentAfterMatch(name, ")")) != null && (idLength = this.parseIdentifierStart(fullName = fullName.trim())) > 0) {
            name = fullName.substring(0, idLength);
            type = "func" + fullName.substring(idLength);
        }
        if (name.length() == 0) {
            throw new CommonException("No name provided");
        }
        EProtection protection = EProtection.PUBLIC;
        if (!parsingMethods && Character.isLowerCase(name.charAt(0))) {
            protection = EProtection.PRIVATE;
        }
        ElementAttributes elementAttributes = new ElementAttributes(protection, new EAttributeFlag[0]);
        JSONArray methods = this.getOptionalJSONArray(object, "methods");
        ArrayList2<StructureElement> children = this.parseElements(methods, true);
        if (!this.isSourceElementLocation(elementSourceFileLoc.getFileLocation())) {
            if (children.size() == 0) {
                return null;
            }
            nameSourceRange = null;
            int startPos = ((StructureElement)children.get(0)).getSourceRange().getStartPos();
            int endPos = ((StructureElement)children.get(children.size() - 1)).getSourceRange().getEndPos();
            sourceRange = SourceRange.srStartToEnd(startPos, endPos);
        }
        return new StructureElement(name, nameSourceRange, sourceRange, elementKind, elementAttributes, type, children);
    }

    protected boolean isSourceElementLocation(Location sourceFileLoc) throws CommonException {
        return this.location == null || this.location.equals(sourceFileLoc);
    }

    protected int parseIdentifierStart(String source) {
        StringCharSource parser = new StringCharSource(source);
        return LexingUtils.matchJavaIdentifier(parser);
    }

    protected StructureElementKind parseKind(String kind, String type) {
        if (kind == null) {
            return null;
        }
        switch (kind.toLowerCase()) {
            case "func": {
                return StructureElementKind.FUNCTION;
            }
            case "var": {
                return StructureElementKind.VARIABLE;
            }
            case "const": {
                return StructureElementKind.CONST;
            }
            case "type": {
                if (type.startsWith("struct")) {
                    return StructureElementKind.STRUCT;
                }
                if (type.startsWith("interface")) {
                    return StructureElementKind.INTERFACE;
                }
                return StructureElementKind.TYPE_DECL;
            }
        }
        return StructureElementKind.VARIABLE;
    }

    public SourceFileStructure parseErrorMessage(String errorMsg) throws CommonException {
        Matcher matcher;
        errorMsg = StringUtil.substringUntilLastMatch(errorMsg, "\n");
        errorMsg = StringUtil.trimStart(errorMsg, "oracle: ");
        errorMsg = StringUtil.trimStart(errorMsg, "guru: ");
        ArrayList2<ParserError> parserProblems = new ArrayList2<ParserError>();
        if (errorMsg.length() > 2 && errorMsg.charAt(1) == ':') {
            errorMsg = errorMsg.substring(2);
        }
        if (!(matcher = GO_MESSAGE_LINE_Regex.matcher(errorMsg)).matches()) {
            throw new CommonException(errorMsg);
        }
        String lineStr = matcher.group(2);
        String columnStr = matcher.group(4);
        String message = matcher.group(5);
        LineColumnPosition lcPost = ToolOutputParseHelper.parseLineColumn(lineStr, columnStr, 1, 1);
        int offset = this.sourceLinesInfo.getValidatedOffset_1(lcPost.line, lcPost.column);
        String source = this.sourceLinesInfo.getSource();
        int length = 1;
        if (offset == source.length()) {
            length = 0;
        } else if (offset < source.length()) {
            length = this.heuristic_determinTokenLength(offset, source);
        }
        SourceRange sr = new SourceRange(offset, length);
        parserProblems.add(new ParserError(ParserErrorTypes.GENERIC_ERROR, sr, message, null));
        return new SourceFileStructure(this.location, CoreUtil.list(new StructureElement[0]), parserProblems);
    }

    protected int heuristic_determinTokenLength(int offset, String source) {
        StringCharSource charSource = new StringCharSource(source);
        charSource.consume(offset);
        int length = LexingUtils.matchJavaIdentifier(charSource);
        if (length == 0) {
            return 1;
        }
        return length;
    }
}

