/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.oracle;

import com.googlecode.goclipse.tooling.env.GoEnvironment;
import com.googlecode.goclipse.tooling.oracle.GoOperationContext;
import com.googlecode.goclipse.tooling.oracle.GuruDescribeOperation;
import melnorme.lang.tooling.common.ops.IOperationMonitor;
import melnorme.lang.tooling.toolchain.ops.AbstractToolOperation;
import melnorme.lang.tooling.toolchain.ops.OperationSoftFailure;
import melnorme.lang.tooling.toolchain.ops.SourceLocation;
import melnorme.lang.tooling.toolchain.ops.ToolOutputParseHelper;
import melnorme.utilbox.concurrency.OperationCancellation;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.core.CoreUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.process.ExternalProcessHelper;
import org.json.JSONException;
import org.json.JSONObject;

public class GuruFindDefinitionOperation
extends GuruDescribeOperation
implements AbstractToolOperation<SourceLocation> {
    protected final GoOperationContext goOperationContext;

    public GuruFindDefinitionOperation(GoOperationContext goOperationContext, String goOraclePath) {
        super(goOraclePath);
        this.goOperationContext = Assert.AssertNamespace.assertNotNull(goOperationContext);
    }

    @Override
    public SourceLocation executeToolOperation(IOperationMonitor om) throws CommonException, OperationCancellation, OperationSoftFailure {
        Location inputLoc = this.goOperationContext.getFileLocation();
        int byteOffset = this.goOperationContext.getByteOffsetFromEncoding(this.goOperationContext.opContext.getOffset());
        GoEnvironment goEnv = this.goOperationContext.goEnv;
        ProcessBuilder pb = this.createProcessBuilder(goEnv, inputLoc, byteOffset);
        ExternalProcessHelper.ExternalProcessResult result = this.goOperationContext.getToolOpService().runProcess(pb, null, om);
        if (result.exitValue != 0) {
            throw new OperationSoftFailure("`guru` did not complete successfully.");
        }
        return this.parseToolResult(result);
    }

    public SourceLocation parseToolResult(ExternalProcessHelper.ExternalProcessResult result) throws CommonException {
        if (result.exitValue != 0) {
            throw new CommonException("Program exited with non-zero status: " + result.exitValue, null);
        }
        String resultMessage = result.getStdOutBytes().toString();
        return new GuruFindDefinitionResultParser().parseJsonResult(resultMessage);
    }

    public static class GuruFindDefinitionResultParser {
        protected SourceLocation parseJsonResult(String output) throws CommonException {
            try {
                return Assert.AssertNamespace.assertNotNull(this.doParseJsonResult(output));
            }
            catch (JSONException e) {
                throw new CommonException("Error parsing JSON output: ", e);
            }
            catch (OperationSoftFailure sf) {
                throw new CommonException(sf.getMessage());
            }
        }

        protected SourceLocation doParseJsonResult(String output) throws JSONException, CommonException, OperationSoftFailure {
            JSONObject describe = new JSONObject(output);
            String desc = describe.getString("desc");
            String detail = describe.getString("detail");
            if (CoreUtil.areEqual(desc, "source file")) {
                return null;
            }
            if (CoreUtil.areEqual(desc, "identifier")) {
                JSONObject value = describe.getJSONObject("value");
                String sourceLocStr = this.getString(value, "objpos", "Definition not available.");
                return ToolOutputParseHelper.parsePathLineColumn(sourceLocStr, ":");
            }
            if (CoreUtil.areEqual(detail, "type")) {
                String DEFINITION_OF = "definition of ";
                if (desc != null && desc.startsWith("definition of ")) {
                    desc = StringUtil.segmentAfterMatch(desc, "definition of ");
                    throw new CommonException("Already at a definition: " + desc);
                }
                JSONObject value = describe.getJSONObject("type");
                String sourceLocStr = this.getString(value, "namepos", "Definition not available.");
                return ToolOutputParseHelper.parsePathLineColumn(sourceLocStr, ":");
            }
            throw new CommonException("Selected position does not refer to a definition. Rather, it's a:\n" + desc);
        }

        protected String getString(JSONObject value, String key, String resultErrorMessage) throws OperationSoftFailure {
            String pathStr = this.getStringOrNull(value, key);
            if (pathStr == null) {
                throw new OperationSoftFailure(resultErrorMessage);
            }
            return pathStr;
        }

        protected String getStringOrNull(JSONObject value, String key) {
            if (value.has(key)) {
                try {
                    return value.getString(key);
                }
                catch (JSONException e) {
                    return null;
                }
            }
            return null;
        }
    }
}

