/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.oracle;

import com.googlecode.goclipse.tooling.env.GoEnvironment;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import melnorme.lang.tooling.common.ISourceBuffer;
import melnorme.lang.tooling.toolchain.ops.IToolOperationService;
import melnorme.lang.tooling.toolchain.ops.SourceOpContext;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.StringUtil;

public class GoOperationContext {
    protected final ISourceBuffer sourceBuffer;
    protected final SourceOpContext opContext;
    protected final IToolOperationService toolOpService;
    protected final GoEnvironment goEnv;

    public GoOperationContext(ISourceBuffer sourceBuffer, SourceOpContext opContext, IToolOperationService toolOpService, GoEnvironment goEnv) {
        this.sourceBuffer = Assert.AssertNamespace.assertNotNull(sourceBuffer);
        this.opContext = Assert.AssertNamespace.assertNotNull(opContext);
        this.toolOpService = Assert.AssertNamespace.assertNotNull(toolOpService);
        this.goEnv = Assert.AssertNamespace.assertNotNull(goEnv);
    }

    public ISourceBuffer getSourceBuffer() {
        return this.sourceBuffer;
    }

    public SourceOpContext getOpContext() {
        return this.opContext;
    }

    public IToolOperationService getToolOpService() {
        return this.toolOpService;
    }

    public GoEnvironment getGoEnv() {
        return this.goEnv;
    }

    public Location getFileLocation() throws CommonException {
        return this.opContext.getFileLocation();
    }

    public int getByteOffsetFromEncoding(int charOffset) throws CommonException {
        Charset charset = StringUtil.UTF8;
        return GoOperationContext.getByteOffsetFromEncoding(this.sourceBuffer.getSource(), charOffset, charset);
    }

    public static int getByteOffsetFromEncoding(String source, int charOffset, Charset charset) throws CommonException {
        CharsetEncoder encoder = charset.newEncoder();
        CharBuffer src = CharBuffer.wrap(source, 0, charOffset);
        try {
            return encoder.encode(src).limit();
        }
        catch (CharacterCodingException e) {
            throw new CommonException("Could not determine byte offset for Unicode string.", e);
        }
    }
}

