/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.oracle;

import com.googlecode.goclipse.tooling.CommonGoToolingTest;
import com.googlecode.goclipse.tooling.oracle.GoDocParser;
import melnorme.utilbox.core.Assert;
import org.junit.Test;

public class GoDocParser_Test
extends CommonGoToolingTest {
    public static String SAMPLE_SRC_A = GoDocParser_Test.getClassResourceAsString(GoDocParser_Test.class, "godoc_sample_A.go");

    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        GoDocParser_Test.assertAreEqual(new GoDocParser().parseDocForDefinitionAt("", 0), null);
        GoDocParser_Test.assertAreEqual(new GoDocParser().parseDocForDefinitionAt("blah", 0), null);
        GoDocParser_Test.assertAreEqual(new GoDocParser().parseDocForDefinitionAt("blah", 4), null);
        GoDocParser_Test.assertAreEqual(new GoDocParser().parseDocForDefinitionAt("", 4), null);
        this.testParseGoDoc(SAMPLE_SRC_A, "Op string", null);
        this.testParseGoDoc(SAMPLE_SRC_A, "// D1", null);
        this.testParseGoDoc(SAMPLE_SRC_A, "url", "D1D2");
        this.testParseGoDoc(SAMPLE_SRC_A, "Error", "E1");
        this.testParseGoDoc(SAMPLE_SRC_A, "struct", "E1");
        this.testParseGoDoc(SAMPLE_SRC_A, "empty_doc", "");
        this.testParseGoDoc(SAMPLE_SRC_A, "\nMARKER_A", "D1D2");
        this.testParseGoDoc(SAMPLE_SRC_A, "\n// D1", "A B C");
        this.testParseGoDoc("\n___", "___", null);
        this.testParseGoDoc(SAMPLE_SRC_A, "test_indent", "indentA indentB");
        this.testParseGoDoc(SAMPLE_SRC_A, "test_indent2", "indent2");
        this.testParseGoDoc(SAMPLE_SRC_A, "test_indent3", "indent3");
    }

    protected void testParseGoDoc(String source, String indexMarker, String expected) {
        int offset = GoDocParser_Test.getIndexOf(source, indexMarker);
        GoDocParser_Test.assertAreEqual(new GoDocParser().parseDocForDefinitionAt(source, offset), expected);
        String source2 = source.replace("\r\n", "\n");
        offset = GoDocParser_Test.getIndexOf(source2, indexMarker);
        GoDocParser_Test.assertAreEqual(new GoDocParser().parseDocForDefinitionAt(source2, offset), expected);
    }

    public static int getIndexOf(String string, String other) {
        int offset = string.indexOf(other);
        Assert.AssertNamespace.assertTrue(offset != -1);
        return offset;
    }
}

