/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.oracle;

import melnorme.lang.utils.parse.LexingUtils;
import melnorme.lang.utils.parse.StringCharSource;

public class GoDocParser {
    public String parseDocForDefinitionAt(String text, int offset) {
        int lineStart;
        StringBuilder docSB = null;
        String commentPrefix = null;
        while ((lineStart = this.findStartPosOfPreviousLine(text, offset)) != -1) {
            if (commentPrefix == null) {
                commentPrefix = this.getCommentPrefix(text, lineStart);
                if (commentPrefix == null) {
                    return null;
                }
            } else if (!text.regionMatches(lineStart, commentPrefix, 0, commentPrefix.length())) break;
            if (docSB == null) {
                docSB = new StringBuilder();
            }
            docSB.insert(0, this.getLineTextAt(text, lineStart + commentPrefix.length()));
            offset = lineStart;
        }
        if (docSB == null) {
            return null;
        }
        return docSB.toString().trim();
    }

    public int findStartPosOfPreviousLine(String source, int offset) {
        int index = source.lastIndexOf(10, offset - 1);
        if (index == -1) {
            return -1;
        }
        if ((index = source.lastIndexOf(10, index - 1)) == -1) {
            return 0;
        }
        return index + 1;
    }

    public String getCommentPrefix(String text, int lineStart) {
        int ix = lineStart;
        while (ix + 1 < text.length()) {
            char ch = text.charAt(ix);
            if (!Character.isSpaceChar(ch) && ch != '\t') {
                if (ch != '/' || text.charAt(ix + 1) != '/') break;
                return text.substring(lineStart, ix + 2);
            }
            ++ix;
        }
        return null;
    }

    public String getLineTextAt(String text, int offset) {
        StringCharSource charSource = new StringCharSource(text);
        charSource.consume(offset);
        return LexingUtils.stringUntilNewline(charSource);
    }
}

