/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.env;

import com.googlecode.goclipse.tooling.CommonGoToolingTest;
import com.googlecode.goclipse.tooling.GoPackageName;
import com.googlecode.goclipse.tooling.env.GoEnvironment;
import com.googlecode.goclipse.tooling.env.GoPath;
import com.googlecode.goclipse.tooling.env.GoWorkspaceLocation;
import java.io.File;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.CollectionUtil;
import melnorme.utilbox.misc.Location;
import melnorme.utilbox.misc.MiscUtil;
import org.junit.Test;

public class GoEnvironmentTest
extends CommonGoToolingTest {
    public static Location SAMPLE_ROOT_PATH = Location.create_fromValid(GoEnvironmentTest.path(MiscUtil.OS_IS_WINDOWS ? "C:/" : "/"));
    private static final Location WS_BAR = TESTS_WORKDIR.resolve_valid("WorkspaceBar");
    private static final Location WS_FOO = TESTS_WORKDIR.resolve_valid("WorkspaceFoo");

    public static GoPackageName goPkg(String pathString) {
        return GoPackageName.fromPath(MiscUtil.createPathOrNull(pathString));
    }

    @Test
    public void test_GoPackageName() throws Exception {
        this.test_GoPackageName$();
    }

    public void test_GoPackageName$() throws Exception {
        GoPackageName.createValid("foo/bar");
        GoPackageName.createValid("foo/bar.asdf");
        GoPackageName.createValid("foo/bar..asdf");
        GoPackageName.createValid("foo/bar...asdf");
        if (MiscUtil.OS_IS_WINDOWS) {
            GoEnvironmentTest.assertEquals(GoPackageName.createValid("foo\\bar").toString(), "foo/bar");
        }
        GoEnvironmentTest.verifyThrows(() -> {
            GoPackageName goPackageName = GoPackageName.createValid("foo/..");
        }, CommonException.class);
        GoEnvironmentTest.verifyThrows(() -> {
            GoPackageName goPackageName = GoPackageName.createValid("./foo");
        }, CommonException.class);
        GoEnvironmentTest.verifyThrows(() -> {
            GoPackageName goPackageName = GoPackageName.createValid("");
        }, CommonException.class);
    }

    @Test
    public void test_GoPath() throws Exception {
        this.test_GoPath$();
    }

    public void test_GoPath$() throws Exception {
        GoPath goPath = new GoPath(WS_FOO + File.pathSeparator + WS_BAR);
        GoEnvironmentTest.assertAreEqual(goPath.findGoPathEntry(WS_FOO.resolve_valid("xxx")), new GoWorkspaceLocation(WS_FOO));
        GoEnvironmentTest.assertAreEqual(goPath.findGoPathEntry(WS_BAR.resolve_valid("xxx")), new GoWorkspaceLocation(WS_BAR));
        GoEnvironmentTest.assertAreEqual(goPath.findGoPathEntry(TESTS_WORKDIR.resolve_valid("xxx")), null);
        GoEnvironmentTest.assertAreEqual(goPath.findGoPackageForLocation(WS_FOO.resolve_valid("xxx/")), null);
        GoEnvironmentTest.assertAreEqual(goPath.findGoPackageForLocation(WS_FOO.resolve_valid("src/xxx/")), GoEnvironmentTest.goPkg("xxx"));
        GoEnvironmentTest.assertAreEqual(goPath.findGoPackageForLocation(WS_FOO.resolve_valid("src/xxx/zzz")), GoEnvironmentTest.goPkg("xxx/zzz"));
        GoEnvironmentTest.assertAreEqual(goPath.findGoPackageForLocation(WS_FOO.resolve_valid("src")), null);
        GoEnvironmentTest.assertAreEqual(goPath.findGoPackageForLocation(WS_BAR.resolve_valid("src/xxx")), GoEnvironmentTest.goPkg("xxx"));
        GoEnvironmentTest.assertAreEqual(goPath.findGoPackageForLocation(WS_BAR.resolve_valid("src/src/src")), GoEnvironmentTest.goPkg("src/src"));
        GoEnvironmentTest.assertAreEqual(goPath.findGoPackageForLocation(TESTS_WORKDIR.resolve_valid("src/xxx")), null);
        goPath = new GoPath("");
        Assert.AssertNamespace.assertTrue(goPath.isEmpty());
        Assert.AssertNamespace.assertTrue(goPath.getGoPathEntries().size() == 0);
        GoEnvironmentTest.assertEquals(goPath.getGoPathString(), "");
        GoEnvironmentTest.verifyThrows(() -> new GoPath("").validate(), CommonException.class, "empty");
    }

    @Test
    public void test() throws Exception {
        this.test$();
    }

    public void test$() throws Exception {
        GoEnvironment goEnv = SAMPLE_GOEnv_1;
        goEnv.validate();
        Location goRootSrc = goEnv.getGoRoot_Location().resolve_valid("src");
        GoEnvironmentTest.assertAreEqual(goEnv.findGoPackageForSourceFile(goRootSrc.resolve_valid("pack/m.go")), GoEnvironmentTest.goPkg("pack"));
        GoEnvironmentTest.assertAreEqual(goEnv.findGoPackageForSourceFile(goRootSrc.resolve_valid("pack/foo/m.go")), GoEnvironmentTest.goPkg("pack/foo"));
        GoEnvironmentTest.assertAreEqual(goEnv.findGoPackageForSourceFile(goRootSrc.resolve_valid("../foo/m.go")), null);
        GoEnvironmentTest.assertAreEqual(goEnv.findGoPackageForSourceFile(SAMPLE_ROOT_PATH), null);
    }

    @Test
    public void testFindSourcePackage() throws Exception {
        this.testFindSourcePackage$();
    }

    public void testFindSourcePackage$() throws Exception {
        GoPath goPath = new GoPath(TR_SAMPLE_GOPATH_ENTRY.toString());
        ArrayList2<GoPackageName> Packages_foo = GoEnvironmentTest.list(GoEnvironmentTest.goPkg("samplePackage"), GoEnvironmentTest.goPkg("samplePackage/subpack"), GoEnvironmentTest.goPkg("samplePackage/subpack/bar"));
        ArrayList2<GoPackageName> Packages_foobar = GoEnvironmentTest.list(GoEnvironmentTest.goPkg("samplePackage2/xxx"));
        ArrayList2<GoPackageName> PackagesAll = new ArrayList2<GoPackageName>().addAll2(Packages_foo).addAll2(Packages_foobar);
        GoWorkspaceLocation goWorkspace = new GoWorkspaceLocation(TR_SAMPLE_GOPATH_ENTRY);
        this.assertEqualSorted(goWorkspace.findSourcePackages(TR_SAMPLE_GOPATH_ENTRY.resolve_valid("src")), PackagesAll);
        this.assertEqualSorted(goWorkspace.findSourcePackages(TR_SAMPLE_GOPATH_ENTRY.resolve_valid("..")), GoEnvironmentTest.list(new Object[0]));
        this.assertEqualSorted(goWorkspace.findSourcePackages(TR_SAMPLE_GOPATH_ENTRY), GoEnvironmentTest.list(new Object[0]));
        this.assertEqualSorted(goWorkspace.findSubPackages(""), PackagesAll);
        this.assertEqualSorted(goWorkspace.findSubPackages("."), PackagesAll);
        this.assertEqualSorted(goWorkspace.findSubPackages("samplePackage"), Packages_foo);
        this.assertEqualSorted(goWorkspace.findSubPackages("samplePackage/."), Packages_foo);
        this.assertEqualSorted(goWorkspace.findSubPackages("samplePackage2/."), Packages_foobar);
        this.assertEqualSorted(goPath.findGoSourcePackages(TR_SAMPLE_GOPATH_ENTRY), PackagesAll);
        this.assertEqualSorted(goPath.findGoSourcePackages(TR_SAMPLE_GOPATH_ENTRY.resolve_valid("src")), PackagesAll);
        this.assertEqualSorted(goPath.findGoSourcePackages(TR_SAMPLE_GOPATH_ENTRY.resolve_valid("src/samplePackage")), Packages_foo);
        this.assertEqualSorted(goPath.findGoSourcePackages(TR_SAMPLE_GOPATH_ENTRY.resolve_valid("src/samplePackage2")), Packages_foobar);
        GoEnvironmentTest.assertAreEqual(goPath.findGoSourcePackages(TR_SAMPLE_GOPATH_ENTRY.resolve_valid("..")), GoEnvironmentTest.list(new Object[0]));
    }

    protected <T extends Comparable<T>> void assertEqualSorted(ArrayList2<T> list1, Indexable<?> list2) {
        CollectionUtil.sort(list1);
        GoEnvironmentTest.assertAreEqual(list1, list2);
    }
}

