/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling.env;

import com.googlecode.goclipse.tooling.GoPackageName;
import com.googlecode.goclipse.tooling.env.GoPath;
import com.googlecode.goclipse.tooling.env.GoRoot;
import com.googlecode.goclipse.tooling.env.GoWorkspaceLocation;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Map;
import melnorme.lang.utils.EnvUtils;
import melnorme.lang.utils.ProcessUtils;
import melnorme.utilbox.collections.Indexable;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.Location;

public class GoEnvironment {
    protected final GoRoot goRoot;
    protected final GoPath goPath;

    public GoEnvironment(GoRoot goRoot, GoPath goPath) {
        this.goRoot = Assert.AssertNamespace.assertNotNull(goRoot);
        this.goPath = Assert.AssertNamespace.assertNotNull(goPath);
    }

    public GoEnvironment(GoRoot goRoot, String goPath) {
        this(goRoot, new GoPath(goPath));
    }

    public GoRoot getGoRoot() {
        return this.goRoot;
    }

    public Location getGoRoot_Location() throws CommonException {
        return this.goRoot.asLocation();
    }

    public GoPath getGoPath() {
        return this.goPath;
    }

    public Indexable<String> getGoPathEntries() {
        return this.goPath.getGoPathEntries();
    }

    public String getGoPathString() {
        return this.goPath.getGoPathString();
    }

    public void validate() throws CommonException {
        this.goRoot.validate();
        this.goPath.validate();
    }

    public static boolean isNullOrEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public GoPackageName findGoPackageForSourceFile(Location goSourceFileLoc) throws CommonException {
        Location goPackageLocation = goSourceFileLoc.getParent();
        return this.findGoPackageForLocation(goPackageLocation);
    }

    public GoPackageName findGoPackageForLocation(Location goPackageLocation) throws CommonException {
        GoPackageName goPackage = this.goRoot.findGoPackageForLocation(goPackageLocation);
        if (goPackage != null) {
            return goPackage;
        }
        return this.goPath.findGoPackageForLocation(goPackageLocation);
    }

    protected static GoPackageName getGoPackageForLocation(Location goPackageLocation, Location sourceRoot) {
        if (goPackageLocation == null || !goPackageLocation.startsWith(sourceRoot)) {
            return null;
        }
        Path goPackageRelPath = sourceRoot.relativize(goPackageLocation);
        if (goPackageRelPath.toString().isEmpty()) {
            return null;
        }
        return GoPackageName.fromPath(goPackageRelPath);
    }

    public Location getBinFolderLocationForSubLocation(Location goPathSubLocation) throws CommonException {
        GoWorkspaceLocation goWorkspace = this.getGoPath().findGoPathEntry(goPathSubLocation);
        if (goWorkspace == null) {
            throw new CommonException(MessageFormat.format("Could not find path `{0}` in a GOPATH entry: ", goPathSubLocation));
        }
        return goWorkspace.getBinLocation();
    }

    public ProcessBuilder createProcessBuilder(Indexable<String> commandLine, Location workingDir) throws CommonException {
        return this.createProcessBuilder(commandLine, workingDir, true);
    }

    public ProcessBuilder createProcessBuilder(Indexable<String> commandLine, Location workingDir, boolean goRootInPath) throws CommonException {
        ProcessBuilder pb = ProcessUtils.createProcessBuilder(commandLine, workingDir);
        this.setupProcessEnv(pb, goRootInPath);
        return pb;
    }

    public void setupProcessEnv(ProcessBuilder pb, boolean goRootInPath) throws CommonException {
        Map<String, String> env = pb.environment();
        this.putMapEntry(env, "GOPATH", this.getGoPathString());
        if (goRootInPath) {
            EnvUtils.addLocationToPathEnv(this.getGoRoot_Location(), pb);
        }
    }

    protected void putMapEntry(Map<String, String> env, String key, String value) {
        if (value != null) {
            env.put(key, value);
        }
    }
}

