/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling;

import com.googlecode.goclipse.tooling.GoPackageName;
import com.googlecode.goclipse.tooling.env.GoWorkspaceLocation;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import melnorme.utilbox.collections.Collection2;
import melnorme.utilbox.collections.HashSet2;
import melnorme.utilbox.collections.LinkedHashMap2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.misc.Location;

public abstract class GoPackagesVisitor {
    protected final Location sourceRoot;
    protected final LinkedHashMap2<GoPackageName, Path> modules = new LinkedHashMap2();
    protected final HashSet2<Path> moduleFiles = new HashSet2();

    public GoPackagesVisitor(GoWorkspaceLocation goWorkspace, Location directoryToVisit) {
        this.sourceRoot = goWorkspace.getSrcLocation();
        if (!directoryToVisit.startsWith(this.sourceRoot)) {
            return;
        }
        try {
            this.visitFolder(directoryToVisit);
        }
        catch (IOException e) {
            throw Assert.AssertNamespace.assertFail("Should not happen, file visit should not throw exception");
        }
    }

    protected abstract FileVisitResult handleFileVisitException(Path var1, IOException var2);

    protected void visitFolder(final Location startingDir) throws IOException {
        if (!startingDir.toFile().exists()) {
            return;
        }
        Files.walkFileTree(startingDir.toPath(), EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                Assert.AssertNamespace.assertTrue(dir.startsWith(startingDir.path));
                Location dirLoc = Location.create_fromValid(dir);
                String fileName = dir.getFileName().toString();
                if (GoPackagesVisitor.this.isIgnoredName(fileName)) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (GoPackagesVisitor.this.isDirectoryAValidGoPackage(dir)) {
                    GoPackageName goPackageName = GoPackageName.fromPath(GoPackagesVisitor.this.sourceRoot.relativize(dirLoc));
                    GoPackagesVisitor.this.addEntry(goPackageName, dir);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return GoPackagesVisitor.this.handleFileVisitException(file, exc);
            }
        });
    }

    protected boolean isIgnoredName(String fileName) {
        return fileName.startsWith("_") || fileName.startsWith(".");
    }

    protected boolean isDirectoryAValidGoPackage(Path goPackageDir) throws IOException {
        CheckDirectoryHasGoSourceFiles checkSourceFiles = new CheckDirectoryHasGoSourceFiles();
        Files.walkFileTree(goPackageDir, EnumSet.of(FileVisitOption.FOLLOW_LINKS), 1, checkSourceFiles);
        return checkSourceFiles.hasGoSourceFiles;
    }

    protected void addEntry(GoPackageName packageName, Path fullPath) {
        Assert.AssertNamespace.assertNotNull(packageName);
        if (packageName.getFullNameAsString().isEmpty()) {
            return;
        }
        this.modules.put(packageName, fullPath);
        this.moduleFiles.add(fullPath);
    }

    public HashSet2<Path> getModuleFiles() {
        return this.moduleFiles;
    }

    public Collection2<GoPackageName> getModuleNames() {
        return this.modules.getKeysView();
    }

    public class CheckDirectoryHasGoSourceFiles
    extends SimpleFileVisitor<Path> {
        public boolean hasGoSourceFiles = false;

        @Override
        public FileVisitResult visitFile(Path filePath, BasicFileAttributes attrs) throws IOException {
            String fileName = filePath.getFileName().toString();
            if (!attrs.isDirectory() && fileName.endsWith(".go") && !GoPackagesVisitor.this.isIgnoredName(fileName)) {
                this.hasGoSourceFiles = true;
                return FileVisitResult.TERMINATE;
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return GoPackagesVisitor.this.handleFileVisitException(file, exc);
        }
    }
}

