/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling;

import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import melnorme.lang.tooling.AbstractElementName2;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.Assert;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.PathUtil;

public class GoPackageName
extends AbstractElementName2
implements Comparable<GoPackageName> {
    public static final String NAME_SEP = "/";

    public GoPackageName(String moduleFullName) {
        super(moduleFullName, NAME_SEP);
    }

    public GoPackageName(String[] segments) {
        super(segments, NAME_SEP);
    }

    public String getCUSimpleName() {
        return this.getLastSegment();
    }

    public static GoPackageName fromPath(Path path) {
        if (path == null) {
            return null;
        }
        Assert.AssertNamespace.assertTrue(!path.isAbsolute());
        return new GoPackageName(path.toString().replace(File.separator, NAME_SEP));
    }

    public static GoPackageName createValid(String goPackageString) throws CommonException {
        if (goPackageString.isEmpty()) {
            throw new CommonException("Go package name is empty.");
        }
        Path goPackagePath = PathUtil.createPath(goPackageString);
        ArrayList2<String> segments = new ArrayList2<String>();
        for (Path pathSegment : goPackagePath) {
            String segmentStr = pathSegment.toString();
            if (segmentStr.isEmpty() || segmentStr.equals(".") || segmentStr.equals("..")) {
                throw new CommonException(MessageFormat.format("Invalid Go package segment: `{0}`", segmentStr));
            }
            segments.add(segmentStr);
        }
        return new GoPackageName(segments.toArray(String.class));
    }

    @Override
    public String toString() {
        return this.elementName;
    }

    public String asString() {
        return this.elementName;
    }

    @Override
    public int compareTo(GoPackageName other) {
        return this.elementName.compareTo(other.elementName);
    }
}

