/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.goclipse.tooling;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import melnorme.lang.tooling.common.ToolSourceMessage;
import melnorme.lang.tooling.toolchain.ops.BuildOutputParser2;
import melnorme.lang.utils.parse.LexingUtils;
import melnorme.lang.utils.parse.StringCharSource;
import melnorme.utilbox.collections.ArrayList2;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.StringUtil;
import melnorme.utilbox.process.ExternalProcessHelper;
import melnorme.utilbox.status.StatusLevel;

public abstract class GoBuildOutputProcessor
extends BuildOutputParser2 {
    protected static final Pattern ERROR_LINE_Regex = Pattern.compile("^([^:\\n]*):(\\d*):(\\d*)?(:)?((warning|error|info):)?\\s(.*)$");
    public static final Pattern WINDOWS_DRIVE_LETTER = Pattern.compile("[a-zA-Z]:\\\\.*", 32);

    @Override
    public ArrayList<ToolSourceMessage> doParseResult(ExternalProcessHelper.ExternalProcessResult result) throws CommonException {
        ArrayList2<ToolSourceMessage> msgs = new ArrayList2<ToolSourceMessage>();
        msgs.addAll((Collection<ToolSourceMessage>)this.parseOutput(result.getStdErrBytes().toString(StringUtil.UTF8)));
        msgs.addAll((Collection<ToolSourceMessage>)this.parseOutput(result.getStdOutBytes().toString(StringUtil.UTF8)));
        return msgs;
    }

    @Override
    protected BuildOutputParser2.ToolMessageData parseMessageData(StringCharSource output) throws CommonException {
        int readChar;
        String outputLine = LexingUtils.consumeLine(output);
        if (!outputLine.contains(":") || outputLine.startsWith("# ") || outputLine.startsWith("WARNING:")) {
            return null;
        }
        String pathDevicePrefix = "";
        if (WINDOWS_DRIVE_LETTER.matcher(outputLine).matches()) {
            pathDevicePrefix = outputLine.substring(0, 2);
            outputLine = outputLine.substring(2);
        }
        BuildOutputParser2.ToolMessageData msgData = new BuildOutputParser2.ToolMessageData();
        Matcher matcher = ERROR_LINE_Regex.matcher(outputLine);
        if (!matcher.matches()) {
            throw this.createUnknownLineSyntaxError(outputLine);
        }
        msgData.pathString = String.valueOf(pathDevicePrefix) + matcher.group(1);
        msgData.lineString = matcher.group(2);
        msgData.columnString = matcher.group(3);
        msgData.messageTypeString = matcher.group(6);
        msgData.messageText = matcher.group(7);
        while ((readChar = output.lookahead()) == 9) {
            String nextLine = LexingUtils.consumeLine(output);
            msgData.messageText = String.valueOf(msgData.messageText) + "\n" + nextLine;
        }
        return msgData;
    }

    @Override
    protected ToolSourceMessage createMessage(BuildOutputParser2.ToolMessageData msgdata) throws CommonException {
        if (msgdata.messageTypeString == null) {
            msgdata.messageTypeString = StatusLevel.ERROR.toString();
        }
        return super.createMessage(msgdata);
    }
}

