/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.debug.ui.viewmodel;

import java.util.Map;
import melnorme.lang.ide.core.LangCore;
import melnorme.utilbox.core.CommonException;
import melnorme.utilbox.misc.StringUtil;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.ErrorLabelText;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.MessagesForDebugVM;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.numberformat.FormattedValueLabelText;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.GdbVariableVMNode;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelAttribute;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.LabelColumnInfo;
import org.eclipse.cdt.dsf.ui.viewmodel.properties.PropertiesBasedLabelProvider;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IElementLabelProvider;

public class GdbVariableVMNode_Override
extends GdbVariableVMNode {
    GdbVariableVMNode_Override(AbstractDMVMProvider provider, DsfSession session, SyncVariableDataAccess syncVariableDataAccess) {
        super(provider, session, syncVariableDataAccess);
    }

    protected IElementLabelProvider createLabelProvider() {
        IElementLabelProvider labelProvider = super.createLabelProvider();
        if (labelProvider instanceof PropertiesBasedLabelProvider) {
            PropertiesBasedLabelProvider provider = (PropertiesBasedLabelProvider)labelProvider;
            GdbVariableVMNode_Override.customizeLabelProvider(provider);
        }
        return labelProvider;
    }

    protected static void customizeLabelProvider(PropertiesBasedLabelProvider provider) {
        LabelColumnInfo columnInfo = provider.getColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE");
        LabelAttribute[] labelAttributes = columnInfo.getLabelAttributes();
        int preferredIndex = -1;
        int i = 0;
        while (i < labelAttributes.length) {
            LabelAttribute labelAttribute = labelAttributes[i];
            if (labelAttribute instanceof FormattedValueLabelText) {
                preferredIndex = i;
            }
            if (labelAttribute instanceof ErrorLabelText) {
                labelAttributes[i] = new ErrorLabelText_Extension();
            }
            ++i;
        }
        if (preferredIndex != -1) {
            labelAttributes[preferredIndex] = new FormattedValueLabelText_Override();
        } else {
            LangCore.logInternalError((Throwable)new CommonException(" Failed to replace CDT's FormattedValueLabelText for the Variables view"));
        }
        provider.setColumnInfo("org.eclipse.cdt.dsf.ui.COLUMN_ID__VALUE", new LabelColumnInfo(labelAttributes));
    }

    public static final class ErrorLabelText_Extension
    extends ErrorLabelText {
        protected static final String[] MESSAGES_TO_TRIM = new String[]{"Cannot access memory at address", "There is no member named"};

        protected Object getPropertyValue(String propertyName, IStatus status, Map<String, Object> properties) {
            if ("error_message".equals(propertyName)) {
                String message = status.getMessage();
                if (status.getChildren().length < 2) {
                    if (message.contains("Error message from debugger back end:")) {
                        String[] stringArray = MESSAGES_TO_TRIM;
                        int n = MESSAGES_TO_TRIM.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String messageToTrim = stringArray[n2];
                            if (message.contains(messageToTrim)) {
                                message = StringUtil.substringFromMatch((String)messageToTrim, (String)message);
                                break;
                            }
                            ++n2;
                        }
                    }
                    return this.replaceNewlines(message);
                }
                StringBuffer buf = new StringBuffer(message);
                IStatus[] iStatusArray = status.getChildren();
                int n = iStatusArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IStatus childStatus = iStatusArray[n3];
                    buf.append(MessagesForDebugVM.ErrorLabelText_Error_message__text_page_break_delimiter);
                    buf.append(this.replaceNewlines(childStatus.getMessage()));
                    ++n3;
                }
                return buf.toString();
            }
            return super.getPropertyValue(propertyName, status, properties);
        }

        protected String replaceNewlines(String message) {
            return message.replaceAll("\n", MessagesForDebugVM.ErrorLabelText_Error_message__text_page_break_delimiter);
        }
    }

    public static class FormattedValueLabelText_Override
    extends FormattedValueLabelText {
        protected String PROP_ACTIVE_FORMAT = "formatted_value_active_format";
        protected String PROP_ACTIVE_FORMAT_VALUE = "formatted_value_active_format_value";

        protected Object getPropertyValue(String propertyName, IStatus status, Map<String, Object> properties) {
            Object activeFormat;
            if (this.PROP_ACTIVE_FORMAT_VALUE.equals(propertyName) && (activeFormat = properties.get(this.PROP_ACTIVE_FORMAT)).equals("Details")) {
                return properties.get(propertyName);
            }
            return super.getPropertyValue(propertyName, status, properties);
        }
    }
}

