/*
 * Decompiled with CFR 0.152.
 */
package melnorme.lang.ide.debug.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import melnorme.lang.ide.core.LangCore;
import melnorme.lang.ide.core.utils.ResourceUtils;
import melnorme.lang.ide.debug.core.GdbLaunchDelegateExtension;
import melnorme.lang.ide.debug.core.LangLaunchConfigurationDelegate_Actual;
import melnorme.lang.ide.debug.core.services.LangDebugServicesExtensions;
import melnorme.utilbox.misc.ArrayUtil;
import melnorme.utilbox.misc.StringUtil;
import org.eclipse.cdt.dsf.debug.service.IDsfDebugServicesFactory;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.service.GDBBackend;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ISourceLocator;

public abstract class AbstractLangDebugLaunchConfigurationDelegate
extends LangLaunchConfigurationDelegate_Actual {
    protected final GdbLaunchDelegateExtension gdbLaunchDelegate = this.createGdbLaunchDelegate();

    protected GdbLaunchDelegateExtension createGdbLaunchDelegate() {
        return new GdbLaunchDelegateExt();
    }

    protected abstract GdbLaunch doCreateGdbLaunch(ILaunchConfiguration var1, String var2, ISourceLocator var3);

    protected LangDebugServicesExtensions doCreateServicesExtensions(IDsfDebugServicesFactory parentServiceFactory) {
        return new LangDebugServicesExtensions(parentServiceFactory);
    }

    protected ILaunch getLaunchForRunMode(ILaunchConfiguration configuration, String mode) throws CoreException {
        throw this.abort_UnsupportedMode(mode);
    }

    public ILaunch getLaunchForDebugMode(ILaunchConfiguration configuration, String mode) throws CoreException {
        ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
        this.setAttributes(workingCopy);
        workingCopy.doSave();
        return this.gdbLaunchDelegate.getLaunch(configuration, mode);
    }

    protected void setAttributes(ILaunchConfigurationWorkingCopy workingCopy) throws CoreException {
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", this.processLauncher.programFileLocation.toString());
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", workingCopy.getAttribute("programArguments", ""));
        workingCopy.setAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", this.processLauncher.workingDir.toString());
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", this.processLauncher.project.getName());
        if (!workingCopy.hasAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN")) {
            workingCopy.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", false);
        }
    }

    protected void launchProcess(ILaunchConfiguration configuration, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        String mode = launch.getLaunchMode();
        this.gdbLaunchDelegate.launch(configuration, mode, launch, monitor);
    }

    public static IProject getProject(ILaunchConfiguration lc) {
        try {
            String prjName = lc.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", null);
            if (StringUtil.emptyAsNull((String)prjName) != null) {
                return ResourceUtils.getProject((String)prjName);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public static String[] convertoToEnvpFormat(HashMap<String, String> envMap) {
        ArrayList<String> envp = new ArrayList<String>(envMap.size());
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            envp.add(String.valueOf(entry.getKey()) + "=" + entry.getValue());
        }
        return (String[])ArrayUtil.createFrom(envp, String.class);
    }

    public static class GDBBackend_Lang
    extends GDBBackend {
        protected final ILaunchConfiguration fLaunchConfiguration;
        protected final IProject project;

        public GDBBackend_Lang(DsfSession session, ILaunchConfiguration lc) {
            super(session, lc);
            this.fLaunchConfiguration = lc;
            this.project = AbstractLangDebugLaunchConfigurationDelegate.getProject(lc);
        }

        protected Process launchGDBProcess(String[] commandLine) throws CoreException {
            String[] launchEnvironment = this.getGDBLaunch_().getLaunchEnvironment();
            if (launchEnvironment != null) {
                LangCore.logWarning((String)"Ignoring previous CDT GDB launch environment");
            }
            HashMap<String, String> envMap = new HashMap<String, String>(System.getenv());
            this.customizeEnvironment(envMap);
            launchEnvironment = AbstractLangDebugLaunchConfigurationDelegate.convertoToEnvpFormat(envMap);
            try {
                return ProcessFactory.getFactory().exec(commandLine, launchEnvironment);
            }
            catch (IOException e) {
                String message = "Error while launching command: " + org.eclipse.cdt.core.parser.util.StringUtil.join((String[])commandLine, (String)" ");
                throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", -1, message, (Throwable)e));
            }
        }

        protected GdbLaunch getGDBLaunch_() {
            return (GdbLaunch)this.getSession().getModelAdapter(ILaunch.class);
        }

        protected void customizeEnvironment(HashMap<String, String> envMap) {
        }
    }

    protected class GdbLaunchDelegateExt
    extends GdbLaunchDelegateExtension {
        protected GdbLaunchDelegateExt() {
        }

        protected GdbLaunch createGdbLaunch(ILaunchConfiguration configuration, String mode, ISourceLocator locator) throws CoreException {
            return AbstractLangDebugLaunchConfigurationDelegate.this.doCreateGdbLaunch(configuration, mode, locator);
        }

        @Override
        protected LangDebugServicesExtensions createServicesExtensions(IDsfDebugServicesFactory parentServiceFactory) {
            return AbstractLangDebugLaunchConfigurationDelegate.this.doCreateServicesExtensions(parentServiceFactory);
        }
    }
}

