/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.wiaj.cannery;

import com.hbm.blocks.ModBlocks;
import com.hbm.items.ModItems;
import com.hbm.main.ResourceManager;
import com.hbm.render.tileentity.RenderStirling;
import com.hbm.util.i18n.I18nUtil;
import com.hbm.wiaj.JarScene;
import com.hbm.wiaj.JarScript;
import com.hbm.wiaj.WorldInAJar;
import com.hbm.wiaj.actions.ActionCreateActor;
import com.hbm.wiaj.actions.ActionRemoveActor;
import com.hbm.wiaj.actions.ActionSetBlock;
import com.hbm.wiaj.actions.ActionSetTile;
import com.hbm.wiaj.actions.ActionSetZoom;
import com.hbm.wiaj.actions.ActionUpdateActor;
import com.hbm.wiaj.actions.ActionWait;
import com.hbm.wiaj.actors.ActorFancyPanel;
import com.hbm.wiaj.actors.ActorTileEntity;
import com.hbm.wiaj.actors.ITileActorRenderer;
import com.hbm.wiaj.cannery.CanneryBase;
import com.hbm.wiaj.cannery.Dummies;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import org.lwjgl.opengl.GL11;

public class CanneryFirebox
extends CanneryBase {
    @Override
    public ItemStack getIcon() {
        return new ItemStack(ModBlocks.heater_firebox);
    }

    @Override
    public String getName() {
        return "cannery.firebox";
    }

    @Override
    public JarScript createScript() {
        WorldInAJar world = new WorldInAJar(5, 5, 5);
        JarScript script = new JarScript(world);
        JarScene scene0 = new JarScene(script);
        scene0.add(new ActionSetZoom(3.0, 0));
        for (int x = world.sizeX - 1; x >= 0; --x) {
            for (int z = 0; z < world.sizeZ; ++z) {
                scene0.add(new ActionSetBlock(x, 0, z, Blocks.field_150336_V));
            }
            scene0.add(new ActionWait(2));
        }
        scene0.add(new ActionWait(8));
        NBTTagCompound firebox = new NBTTagCompound();
        firebox.func_74780_a("x", 2.0);
        firebox.func_74780_a("y", 1.0);
        firebox.func_74780_a("z", 2.0);
        firebox.func_74768_a("rotation", 5);
        scene0.add(new ActionCreateActor(0, new ActorTileEntity(new ActorFirebox(), firebox)));
        scene0.add(new ActionWait(10));
        scene0.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, -10, new Object[][]{{I18nUtil.resolveKey("cannery.firebox.0", new Object[0])}}, 150).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene0.add(new ActionWait(60));
        scene0.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, -10, new Object[][]{{I18nUtil.resolveKey("cannery.firebox.1", new Object[0])}}, 250).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene0.add(new ActionWait(60));
        scene0.add(new ActionRemoveActor(1));
        scene0.add(new ActionWait(5));
        scene0.add(new ActionUpdateActor(0, "open", true));
        scene0.add(new ActionWait(30));
        scene0.add(new ActionUpdateActor(0, "isOn", true));
        scene0.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, -50, 40, new Object[][]{{new ItemStack(Items.field_151044_h)}}, 0).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.RIGHT)));
        scene0.add(new ActionWait(10));
        scene0.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, -50, 40, new Object[][]{{new ItemStack(ModItems.coke)}}, 0).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.RIGHT)));
        scene0.add(new ActionWait(10));
        scene0.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, -50, 40, new Object[][]{{new ItemStack(ModItems.solid_fuel)}}, 0).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.RIGHT)));
        scene0.add(new ActionWait(10));
        scene0.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, -50, 40, new Object[][]{{new ItemStack(ModItems.rocket_fuel)}}, 0).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.RIGHT)));
        scene0.add(new ActionWait(10));
        scene0.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, -50, 40, new Object[][]{{new ItemStack(ModItems.solid_fuel_bf)}}, 0).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.RIGHT)));
        scene0.add(new ActionWait(10));
        scene0.add(new ActionRemoveActor(1));
        scene0.add(new ActionWait(10));
        scene0.add(new ActionUpdateActor(0, "open", false));
        scene0.add(new ActionWait(30));
        scene0.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, -10, new Object[][]{{I18nUtil.resolveKey("cannery.firebox.2", new Object[0])}}, 250).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene0.add(new ActionWait(80));
        scene0.add(new ActionCreateActor(1, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, -10, new Object[][]{{I18nUtil.resolveKey("cannery.firebox.3", new Object[0])}}, 250).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene0.add(new ActionWait(60));
        scene0.add(new ActionRemoveActor(1));
        scene0.add(new ActionWait(10));
        JarScene scene1 = new JarScene(script);
        NBTTagCompound stirling = new NBTTagCompound();
        stirling.func_74780_a("x", 2.0);
        stirling.func_74780_a("y", 2.0);
        stirling.func_74780_a("z", 2.0);
        stirling.func_74768_a("rotation", 2);
        stirling.func_74757_a("hasCog", true);
        scene1.add(new ActionCreateActor(1, new ActorTileEntity(new RenderStirling(), stirling)));
        scene1.add(new ActionUpdateActor(1, "speed", Float.valueOf(0.0f)));
        scene1.add(new ActionWait(10));
        scene1.add(new ActionCreateActor(2, new ActorFancyPanel(Minecraft.func_71410_x().field_71466_p, 0, -45, new Object[][]{{I18nUtil.resolveKey("cannery.firebox.4", new Object[0])}}, 250).setColors(colorCopper).setOrientation(ActorFancyPanel.Orientation.BOTTOM)));
        scene1.add(new ActionWait(60));
        scene1.add(new ActionRemoveActor(2));
        scene1.add(new ActionWait(10));
        for (int i = 0; i < 60; ++i) {
            scene1.add(new ActionUpdateActor(1, "speed", Float.valueOf((float)i / 5.0f)));
            scene1.add(new ActionWait(1));
        }
        scene1.add(new ActionSetTile(1, 2, 2, new Dummies.JarDummyConnector()));
        scene1.add(new ActionSetTile(0, 2, 2, new Dummies.JarDummyConnector()));
        scene1.add(new ActionSetTile(0, 1, 2, new Dummies.JarDummyConnector()));
        scene1.add(new ActionSetTile(0, 1, 3, new Dummies.JarDummyConnector()));
        scene1.add(new ActionSetBlock(0, 2, 2, ModBlocks.red_cable));
        scene1.add(new ActionSetBlock(0, 1, 2, ModBlocks.red_cable));
        scene1.add(new ActionSetBlock(0, 1, 3, ModBlocks.machine_detector, 0));
        scene1.add(new ActionWait(10));
        scene1.add(new ActionSetBlock(0, 1, 3, ModBlocks.machine_detector, 1));
        scene1.add(new ActionWait(100));
        script.addScene(scene0).addScene(scene1);
        return script;
    }

    public static class ActorFirebox
    implements ITileActorRenderer {
        @Override
        public void renderActor(WorldInAJar world, int ticks, float interp, NBTTagCompound data) {
            double x = data.func_74769_h("x");
            double y = data.func_74769_h("y");
            double z = data.func_74769_h("z");
            int rotation = data.func_74762_e("rotation");
            boolean isOn = data.func_74767_n("isOn");
            float doorAngle = data.func_74760_g("angle");
            float prevDoorAngle = data.func_74760_g("lastAngle");
            GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
            GL11.glEnable((int)2896);
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)2884);
            switch (rotation) {
                case 3: {
                    GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 5: {
                    GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 2: {
                    GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                    break;
                }
                case 4: {
                    GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
            }
            ITileActorRenderer.bindTexture(ResourceManager.heater_firebox_tex);
            ResourceManager.heater_firebox.renderPart("Main");
            GL11.glPushMatrix();
            float door = prevDoorAngle + (doorAngle - prevDoorAngle) * interp;
            GL11.glTranslated((double)1.375, (double)0.0, (double)0.375);
            GL11.glRotatef((float)door, (float)0.0f, (float)-1.0f, (float)0.0f);
            GL11.glTranslated((double)-1.375, (double)0.0, (double)-0.375);
            ResourceManager.heater_firebox.renderPart("Door");
            GL11.glPopMatrix();
            if (isOn) {
                GL11.glPushMatrix();
                GL11.glPushAttrib((int)64);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)2884);
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
                ResourceManager.heater_firebox.renderPart("InnerBurning");
                GL11.glEnable((int)2896);
                GL11.glPopAttrib();
                GL11.glPopMatrix();
            } else {
                ResourceManager.heater_firebox.renderPart("InnerEmpty");
            }
        }

        @Override
        public void updateActor(int ticks, NBTTagCompound data) {
            boolean open = data.func_74767_n("open");
            float doorAngle = data.func_74760_g("angle");
            data.func_74776_a("lastAngle", doorAngle);
            float swingSpeed = doorAngle / 10.0f + 3.0f;
            doorAngle = open ? (doorAngle += swingSpeed) : (doorAngle -= swingSpeed);
            doorAngle = MathHelper.func_76131_a((float)doorAngle, (float)0.0f, (float)135.0f);
            data.func_74776_a("angle", doorAngle);
        }
    }
}

